/*
 * Decompiled with CFR 0.152.
 */
package com.github.aidensuen.mongo.spring.annotation;

import com.github.aidensuen.mongo.spring.annotation.MongoDaoScan;
import com.github.aidensuen.mongo.spring.mongodao.ClassPathMongoDaoScanner;
import com.github.aidensuen.mongo.spring.mongodao.MongoDaoFactoryBean;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class MongoDaoScannerRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware {
    public static final Logger LOGGER = LoggerFactory.getLogger(MongoDaoScannerRegistrar.class);
    private Environment environment;

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        Class mongoDaorFactoryBeanClass;
        Class generatorClass;
        Class markerInterface;
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(MongoDaoScan.class.getName()));
        ClassPathMongoDaoScanner scanner = new ClassPathMongoDaoScanner(registry);
        Class annotationClass = attributes.getClass("annotationClass");
        if (!Annotation.class.equals((Object)annotationClass)) {
            scanner.setAnnotationClass(annotationClass);
        }
        if (!Class.class.equals((Object)(markerInterface = attributes.getClass("markerInterface")))) {
            scanner.setMarkerInterface(markerInterface);
        }
        if (!BeanNameGenerator.class.equals((Object)(generatorClass = attributes.getClass("nameGenerator")))) {
            scanner.setBeanNameGenerator((BeanNameGenerator)BeanUtils.instantiateClass((Class)generatorClass));
        }
        if (!MongoDaoFactoryBean.class.equals((Object)(mongoDaorFactoryBeanClass = attributes.getClass("factoryBean")))) {
            scanner.setMongoDaoFactoryBean((MongoDaoFactoryBean)((Object)BeanUtils.instantiateClass((Class)mongoDaorFactoryBeanClass)));
        }
        scanner.setMongoSessionTemplateBeanName(attributes.getString("mongoSessionTemplateRef"));
        scanner.setMongoSessionFactoryBeanName(attributes.getString("mongoSessionFactoryRef"));
        String mongoDaoRepositoryRef = attributes.getString("mongoDaoRepositoryRef");
        String[] properties = attributes.getStringArray("properties");
        if (StringUtils.hasText((String)mongoDaoRepositoryRef)) {
            scanner.setMongoDaoRepositoryBeaName(mongoDaoRepositoryRef);
        } else if (properties != null && properties.length > 0) {
            scanner.setMongoDaoProperties(properties);
        } else {
            try {
                scanner.setMongoDaoProperties(this.environment);
            }
            catch (Exception e) {
                LOGGER.warn(e.toString());
            }
        }
        ArrayList<String> basePackages = new ArrayList<String>();
        for (String pkg : attributes.getStringArray("value")) {
            if (!StringUtils.hasText((String)pkg)) continue;
            basePackages.add(pkg);
        }
        for (String pkg : attributes.getStringArray("basePackages")) {
            if (!StringUtils.hasText((String)pkg)) continue;
            basePackages.add(pkg);
        }
        for (Class clazz : attributes.getClassArray("basePackageClasses")) {
            basePackages.add(ClassUtils.getPackageName((Class)clazz));
        }
        scanner.registerFilters();
        scanner.doScan(StringUtils.toStringArray(basePackages));
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

