/*
 * Decompiled with CFR 0.152.
 */
package com.github.aidensuen.mongo.spring.mongodao;

import com.github.aidensuen.mongo.annotation.RegisterMongoDao;
import com.github.aidensuen.mongo.core.MongoDaoRepository;
import com.github.aidensuen.mongo.exception.MongoDaoException;
import com.github.aidensuen.mongo.session.MongoSessionFactory;
import com.github.aidensuen.mongo.spring.MongoSessionTemplate;
import com.github.aidensuen.mongo.spring.mongodao.MongoDaoFactoryBean;
import com.github.aidensuen.util.SpringBootBindUtil;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Properties;
import java.util.Set;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.env.Environment;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.StringUtils;

public class ClassPathMongoDaoScanner
extends ClassPathBeanDefinitionScanner {
    private MongoSessionTemplate mongoSessionTemplate;
    private MongoSessionFactory mongoSessionFactory;
    private String mongoSessionFactoryBeanName;
    private String mongoSessionTemplateBeanName;
    private boolean addToConfig = true;
    private final String repositoryName = "mongoDaoRepository";
    private Class<? extends Annotation> annotationClass;
    private Class<?> markerInterface;
    private MongoDaoRepository mongoDaoRepository;
    private String mongoDaoRepositoryBeaName;
    private MongoDaoFactoryBean<?> mongoDaoFactoryBean = new MongoDaoFactoryBean();
    private final String registerMongoDaoName = RegisterMongoDao.class.getName();

    public ClassPathMongoDaoScanner(BeanDefinitionRegistry registry) {
        super(registry, false);
    }

    public void registerFilters() {
        boolean acceptAllInterfaces = true;
        if (this.annotationClass != null) {
            this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(this.annotationClass));
            acceptAllInterfaces = false;
        }
        if (this.markerInterface != null) {
            this.addIncludeFilter((TypeFilter)new AssignableTypeFilter(this.markerInterface){

                protected boolean matchClassName(String className) {
                    this.logger.info((Object)className);
                    return false;
                }
            });
            acceptAllInterfaces = false;
        }
        if (acceptAllInterfaces) {
            this.addIncludeFilter(new TypeFilter(){

                public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
                    return true;
                }
            });
        }
        this.addExcludeFilter(new TypeFilter(){

            public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
                String className = metadataReader.getClassMetadata().getClassName();
                if (className.endsWith("package-info")) {
                    return true;
                }
                return metadataReader.getAnnotationMetadata().hasAnnotation(ClassPathMongoDaoScanner.this.registerMongoDaoName);
            }
        });
    }

    public Set<BeanDefinitionHolder> doScan(String ... basePackages) {
        return this.doScan0(basePackages);
    }

    private Set<BeanDefinitionHolder> doScan0(String ... basePackages) {
        Set beanDefinitions = super.doScan(basePackages);
        if (beanDefinitions.isEmpty()) {
            this.logger.warn((Object)("No Mongo dao was found in '" + Arrays.toString(basePackages) + "' package. Please check your configuration."));
        } else {
            this.processBeanDefinitions(beanDefinitions);
        }
        return beanDefinitions;
    }

    private void processBeanDefinitions(Set<BeanDefinitionHolder> beanDefinitions) {
        for (BeanDefinitionHolder holder : beanDefinitions) {
            GenericBeanDefinition definition = (GenericBeanDefinition)holder.getBeanDefinition();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Creating MongoDaoFactoryBean with name '" + holder.getBeanName() + "' and '" + definition.getBeanClassName() + "' mongoDaoInterface"));
            }
            definition.getConstructorArgumentValues().addGenericArgumentValue((Object)definition.getBeanClassName());
            definition.setBeanClass(((Object)this.mongoDaoFactoryBean).getClass());
            if (StringUtils.hasText((String)this.mongoDaoRepositoryBeaName)) {
                definition.getPropertyValues().add("mongoDaoRepository", (Object)new RuntimeBeanReference(this.mongoDaoRepositoryBeaName));
            } else {
                if (this.mongoDaoRepository == null) {
                    this.mongoDaoRepository = new MongoDaoRepository();
                }
                definition.getPropertyValues().add("mongoDaoRepository", (Object)this.mongoDaoRepository);
            }
            definition.getPropertyValues().add("addToConfig", (Object)this.addToConfig);
            boolean explicitFactoryUsed = false;
            if (StringUtils.hasText((String)this.mongoSessionFactoryBeanName)) {
                definition.getPropertyValues().add("mongoSessionFactory", (Object)new RuntimeBeanReference(this.mongoSessionFactoryBeanName));
                explicitFactoryUsed = true;
            } else if (this.mongoSessionFactory != null) {
                definition.getPropertyValues().add("mongoSessionFactory", (Object)this.mongoSessionFactory);
                explicitFactoryUsed = true;
            }
            if (StringUtils.hasText((String)this.mongoSessionTemplateBeanName)) {
                if (explicitFactoryUsed) {
                    this.logger.warn((Object)"Cannot use both: mongoSessionTemplate and mongoSessionFactory together. mongoSessionFactory is ignored.");
                }
                definition.getPropertyValues().add("mongoSessionTemplate", (Object)new RuntimeBeanReference(this.mongoSessionTemplateBeanName));
                explicitFactoryUsed = true;
            } else if (this.mongoSessionTemplate != null) {
                if (explicitFactoryUsed) {
                    this.logger.warn((Object)"Cannot use both: mongoSessionTemplate and mongoSessionFactory together. mongoSessionFactory is ignored.");
                }
                definition.getPropertyValues().add("mongoSessionTemplate", (Object)this.mongoSessionTemplate);
                explicitFactoryUsed = true;
            }
            if (explicitFactoryUsed) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Enabling autowire by type for MongoDaoFactoryBean with name '" + holder.getBeanName() + "'."));
            }
            definition.setAutowireMode(2);
        }
    }

    protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
        return beanDefinition.getMetadata().isInterface() && beanDefinition.getMetadata().isIndependent();
    }

    protected boolean checkCandidate(String beanName, BeanDefinition beanDefinition) {
        if (super.checkCandidate(beanName, beanDefinition)) {
            return true;
        }
        this.logger.warn((Object)("Skipping MongoDaoFactoryBean with name '" + beanName + "' and '" + beanDefinition.getBeanClassName() + "' mongoDaoInterface. Bean already defined with the same name!"));
        return false;
    }

    public Class<? extends Annotation> getAnnotationClass() {
        return this.annotationClass;
    }

    public void setAnnotationClass(Class<? extends Annotation> annotationClass) {
        this.annotationClass = annotationClass;
    }

    public Class<?> getMarkerInterface() {
        return this.markerInterface;
    }

    public void setMarkerInterface(Class<?> markerInterface) {
        this.markerInterface = markerInterface;
    }

    public void setMongoDaoRepository(MongoDaoRepository mongoDaoRepository) {
        this.mongoDaoRepository = mongoDaoRepository;
    }

    public void setAddToConfig(boolean addToConfig) {
        this.addToConfig = addToConfig;
    }

    public String getRepositoryName() {
        return "mongoDaoRepository";
    }

    public void setMongoDaoFactoryBean(MongoDaoFactoryBean<?> mongoDaoFactoryBean) {
        this.mongoDaoFactoryBean = mongoDaoFactoryBean != null ? mongoDaoFactoryBean : new MongoDaoFactoryBean();
    }

    public void setMongoDaoProperties(String[] properties) {
        if (this.mongoDaoRepository == null) {
            this.mongoDaoRepository = new MongoDaoRepository();
        }
        Properties props = new Properties();
        for (String property : properties) {
            int index = (property = property.trim()).indexOf("=");
            if (index < 0) {
                throw new MongoDaoException("incorrect format in properties");
            }
            props.put(property.substring(0, index).trim(), property.substring(index + 1).trim());
        }
        this.mongoDaoRepository.setProperties(props);
    }

    public void setMongoDaoProperties(Environment environment) {
        if (this.mongoDaoRepository == null) {
            this.mongoDaoRepository = new MongoDaoRepository();
        }
        Properties p = (Properties)SpringBootBindUtil.bind((Environment)environment, Properties.class, (String)"mongodao");
        this.mongoDaoRepository.setProperties(p);
    }

    public void setMongoDaoRepositoryBeaName(String mongoDaoRepositoryBeaName) {
        this.mongoDaoRepositoryBeaName = mongoDaoRepositoryBeaName;
    }

    public void setMongoSessionFactory(MongoSessionFactory mongoSessionFactory) {
        this.mongoSessionFactory = mongoSessionFactory;
    }

    public void setMongoSessionFactoryBeanName(String mongoSessionFactoryBeanName) {
        this.mongoSessionFactoryBeanName = mongoSessionFactoryBeanName;
    }

    public void setMongoSessionTemplate(MongoSessionTemplate mongoSessionTemplate) {
        this.mongoSessionTemplate = mongoSessionTemplate;
    }

    public void setMongoSessionTemplateBeanName(String mongoSessionTemplateBeanName) {
        this.mongoSessionTemplateBeanName = mongoSessionTemplateBeanName;
    }
}

