/*
 * Decompiled with CFR 0.152.
 */
package com.github.aidensuen.mongo.spring.mongodao;

import com.github.aidensuen.mongo.core.MongoDaoRepository;
import com.github.aidensuen.mongo.session.Configuration;
import com.github.aidensuen.mongo.spring.support.MongoDaoSupport;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.util.Assert;

public class MongoDaoFactoryBean<T>
extends MongoDaoSupport
implements FactoryBean<T> {
    private boolean addToConfig = true;
    private Class<T> mongoDaoInterface;
    private MongoDaoRepository mongoDaoRepository;

    public MongoDaoFactoryBean() {
    }

    public MongoDaoFactoryBean(Class<T> mongoDaoInterface) {
        this.mongoDaoInterface = mongoDaoInterface;
    }

    @Override
    protected void checkDaoConfig() {
        super.checkDaoConfig();
        Assert.notNull(this.mongoDaoInterface, (String)"Property 'mongoDaoInterface' is required");
        Configuration configuration = this.getMongoSession().getConfiguration();
        if (this.addToConfig && !configuration.hasMongoDao(this.mongoDaoInterface)) {
            try {
                configuration.addMongoDao(this.mongoDaoInterface);
            }
            catch (Exception e) {
                this.logger.error((Object)("Error while adding the dao '" + this.mongoDaoInterface + "' to configuration."), (Throwable)e);
                throw new IllegalArgumentException(e);
            }
        }
        if (configuration.hasMongoDao(this.mongoDaoInterface) && this.mongoDaoInterface != null && this.mongoDaoRepository.isExtendCommonMongoDao(this.mongoDaoInterface)) {
            this.mongoDaoRepository.processConfiguration(this.getMongoSession().getConfiguration(), this.mongoDaoInterface);
        }
    }

    public T getObject() throws Exception {
        return (T)this.getMongoSession().getMongoDao(this.mongoDaoInterface);
    }

    public Class<T> getObjectType() {
        return this.mongoDaoInterface;
    }

    public boolean isSingleton() {
        return true;
    }

    public MongoDaoRepository getMongoDaoRepository() {
        return this.mongoDaoRepository;
    }

    public void setMongoDaoRepository(MongoDaoRepository mongoDaoRepository) {
        this.mongoDaoRepository = mongoDaoRepository;
    }

    public void setAddToConfig(boolean addToConfig) {
        this.addToConfig = addToConfig;
    }
}

