/*
 * Decompiled with CFR 0.152.
 */
package com.github.aidensuen.mongo.spring.mongodao;

import com.github.aidensuen.mongo.common.Marker;
import com.github.aidensuen.mongo.core.MongoDaoRepository;
import com.github.aidensuen.mongo.session.MongoSessionFactory;
import com.github.aidensuen.mongo.spring.MongoSessionTemplate;
import com.github.aidensuen.mongo.spring.mongodao.ClassPathMongoDaoScanner;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyResourceConfigurer;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class MongoDaoScannerConfigurer
implements BeanDefinitionRegistryPostProcessor,
InitializingBean,
ApplicationContextAware,
BeanNameAware {
    private boolean addToConfig = true;
    private MongoSessionTemplate mongoSessionTemplate;
    private MongoSessionFactory mongoSessionFactory;
    private String mongoSessionFactoryBeanName;
    private String mongoSessionTemplateBeanName;
    private String basePackage;
    private Class<? extends Annotation> annotationClass;
    private Class<?> markerInterface;
    private String beanName;
    private BeanNameGenerator nameGenerator;
    private ApplicationContext applicationContext;
    private MongoDaoRepository mongoDaoRepository = new MongoDaoRepository();
    private boolean processPropertyPlaceHolders;

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.basePackage, (String)"Property 'basePackage' is required");
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        if (this.processPropertyPlaceHolders) {
            this.processPropertyPlaceHolders();
        }
        ClassPathMongoDaoScanner scanner = new ClassPathMongoDaoScanner(registry);
        scanner.setAnnotationClass(this.annotationClass);
        scanner.setMarkerInterface(this.markerInterface);
        scanner.setAddToConfig(this.addToConfig);
        scanner.setMongoSessionFactory(this.mongoSessionFactory);
        scanner.setMongoSessionFactoryBeanName(this.mongoSessionFactoryBeanName);
        scanner.setResourceLoader((ResourceLoader)this.applicationContext);
        scanner.setMongoSessionTemplate(this.mongoSessionTemplate);
        scanner.setMongoSessionTemplateBeanName(this.mongoSessionTemplateBeanName);
        scanner.setBeanNameGenerator(this.nameGenerator);
        scanner.registerFilters();
        scanner.setMongoDaoRepository(this.mongoDaoRepository);
        scanner.scan(StringUtils.tokenizeToStringArray((String)this.basePackage, (String)",; \t\n"));
    }

    private void processPropertyPlaceHolders() {
        Map prcs = this.applicationContext.getBeansOfType(PropertyResourceConfigurer.class);
        if (!prcs.isEmpty() && this.applicationContext instanceof ConfigurableApplicationContext) {
            BeanDefinition mapperScannerBean = ((ConfigurableApplicationContext)this.applicationContext).getBeanFactory().getBeanDefinition(this.beanName);
            DefaultListableBeanFactory factory = new DefaultListableBeanFactory();
            factory.registerBeanDefinition(this.beanName, mapperScannerBean);
            for (PropertyResourceConfigurer prc : prcs.values()) {
                prc.postProcessBeanFactory((ConfigurableListableBeanFactory)factory);
            }
            MutablePropertyValues values = mapperScannerBean.getPropertyValues();
            this.basePackage = this.updatePropertyValue("basePackage", (PropertyValues)values);
            this.mongoSessionFactoryBeanName = this.updatePropertyValue("mongoSessionFactoryBeanName", (PropertyValues)values);
            this.mongoSessionTemplateBeanName = this.updatePropertyValue("mongoSessionTemplateBeanName", (PropertyValues)values);
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public Class<? extends Annotation> getAnnotationClass() {
        return this.annotationClass;
    }

    public void setAnnotationClass(Class<? extends Annotation> annotationClass) {
        this.annotationClass = annotationClass;
    }

    public Class<?> getMarkerInterface() {
        return this.markerInterface;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setAddToConfig(boolean addToConfig) {
        this.addToConfig = addToConfig;
    }

    public BeanNameGenerator getNameGenerator() {
        return this.nameGenerator;
    }

    public void setNameGenerator(BeanNameGenerator nameGenerator) {
        this.nameGenerator = nameGenerator;
    }

    public MongoSessionFactory getMongoSessionFactory() {
        return this.mongoSessionFactory;
    }

    public void setMongoSessionFactory(MongoSessionFactory mongoSessionFactory) {
        this.mongoSessionFactory = mongoSessionFactory;
    }

    public void setMongoSessionTemplate(MongoSessionTemplate mongoSessionTemplate) {
        this.mongoSessionTemplate = mongoSessionTemplate;
    }

    public MongoDaoRepository getMongoDaoRepository() {
        return this.mongoDaoRepository;
    }

    public void setMongoDaoRepository(MongoDaoRepository mongoDaoRepository) {
        this.mongoDaoRepository = mongoDaoRepository;
    }

    public void setProcessPropertyPlaceHolders(boolean processPropertyPlaceHolders) {
        this.processPropertyPlaceHolders = processPropertyPlaceHolders;
    }

    public String getMongoSessionFactoryBeanName() {
        return this.mongoSessionFactoryBeanName;
    }

    public void setMongoSessionFactoryBeanName(String mongoSessionFactoryBeanName) {
        this.mongoSessionFactoryBeanName = mongoSessionFactoryBeanName;
    }

    public void setProperties(Properties properties) {
        this.mongoDaoRepository.setProperties(properties);
    }

    public void setMarkerInterface(Class<?> markerInterface) {
        this.markerInterface = markerInterface;
        if (Marker.class.isAssignableFrom(markerInterface)) {
            this.mongoDaoRepository.registerMongoDao(markerInterface);
        }
    }

    private String updatePropertyValue(String propertyName, PropertyValues values) {
        PropertyValue property = values.getPropertyValue(propertyName);
        if (property == null) {
            return null;
        }
        Object value = property.getValue();
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return value.toString();
        }
        if (value instanceof TypedStringValue) {
            return ((TypedStringValue)value).getValue();
        }
        return null;
    }

    public void setMongoSessionTemplateBeanName(String mongoSessionTemplateBeanName) {
        this.mongoSessionTemplateBeanName = mongoSessionTemplateBeanName;
    }
}

