/*
 * Decompiled with CFR 0.152.
 */
package com.github.aistomin.maven.browser;

import com.github.aistomin.maven.browser.MavenArtifact;
import com.github.aistomin.maven.browser.MavenDependency;
import com.github.aistomin.maven.browser.MvnArtifact;
import com.github.aistomin.maven.browser.MvnArtifactVersion;
import com.github.aistomin.maven.browser.MvnDependency;
import com.github.aistomin.maven.browser.MvnPackagingType;
import java.util.Arrays;
import org.json.simple.JSONObject;

public final class MavenArtifactVersion
implements MvnArtifactVersion {
    private static final int MAGIC_NUMBER = 31;
    private final MvnArtifact art;
    private final String ver;
    private final Long release;
    private final MvnPackagingType type;

    public MavenArtifactVersion(MvnArtifact artifact, String version, MvnPackagingType packaging, Long timestamp) {
        this.art = artifact;
        this.ver = version;
        this.type = packaging;
        this.release = timestamp;
    }

    public MavenArtifactVersion(JSONObject json) {
        this(new MavenArtifact(json), (String)json.get((Object)"v"), Arrays.stream(MvnPackagingType.values()).filter(item -> item.packaging().equals(json.get((Object)"p"))).findFirst().orElse(MvnPackagingType.JAR), (Long)json.get((Object)"timestamp"));
    }

    @Override
    public MvnArtifact artifact() {
        return this.art;
    }

    @Override
    public String name() {
        return this.ver;
    }

    @Override
    public Long releaseTimestamp() {
        return this.release;
    }

    @Override
    public String identifier() {
        return String.format("%s:%s", this.artifact().identifier(), this.name());
    }

    @Override
    public MvnDependency dependency() {
        return new MavenDependency(this);
    }

    @Override
    public MvnPackagingType packaging() {
        return this.type;
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && this.art.equals(((MavenArtifactVersion)obj).art) && this.ver.equals(((MavenArtifactVersion)obj).ver);
    }

    public int hashCode() {
        return 31 * this.art.hashCode() + this.ver.hashCode();
    }

    public String toString() {
        return this.identifier();
    }
}

