/*
 * Decompiled with CFR 0.152.
 */
package com.github.aistomin.maven.browser;

import com.github.aistomin.maven.browser.MavenArtifact;
import com.github.aistomin.maven.browser.MavenArtifactVersion;
import com.github.aistomin.maven.browser.MvnArtifact;
import com.github.aistomin.maven.browser.MvnArtifactVersion;
import com.github.aistomin.maven.browser.MvnException;
import com.github.aistomin.maven.browser.MvnRepo;
import java.io.IOException;
import java.lang.module.ModuleDescriptor;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public final class MavenCentral
implements MvnRepo {
    public static final int MAX_ROWS = 20;
    public static final String ENCODING = "UTF-8";
    private final String repo;

    public MavenCentral(String repository) {
        this.repo = repository;
    }

    public MavenCentral() {
        this("https://search.maven.org/solrsearch/select");
    }

    @Override
    public List<MvnArtifact> findArtifacts(String str) throws MvnException {
        return this.findArtifacts(str, 0, 20);
    }

    @Override
    public List<MvnArtifact> findArtifacts(String str, Integer start, Integer rows) throws MvnException {
        try {
            String result = IOUtils.toString((URI)URI.create(String.format("%s?q=%s&start=%d&rows=%d&wt=json", this.repo, str, start, rows)), (String)ENCODING);
            return MavenCentral.parseResponse(result).stream().map(MavenArtifact::new).collect(Collectors.toList());
        }
        catch (IOException | ParseException exception) {
            throw new MvnException(exception);
        }
    }

    @Override
    public List<MvnArtifactVersion> findVersions(MvnArtifact artifact) throws MvnException {
        return this.findVersions(artifact, 0, 20);
    }

    @Override
    public List<MvnArtifactVersion> findVersions(MvnArtifact artifact, Integer start, Integer rows) throws MvnException {
        try {
            String res = IOUtils.toString((URI)URI.create(String.format("%s?q=g:%s+AND+a:%s&core=gav&start=%d&rows=%d&wt=json", this.repo, artifact.group().name(), artifact.name(), start, rows)), (String)ENCODING);
            return MavenCentral.parseResponse(res).stream().map(MavenArtifactVersion::new).collect(Collectors.toList());
        }
        catch (IOException | ParseException exception) {
            throw new MvnException(exception);
        }
    }

    @Override
    public List<MvnArtifactVersion> findVersionsNewerThan(MvnArtifactVersion version) throws MvnException {
        return this.findArtifactVersionsWithFilter(version, MavenCentral::isFirstVersionBiggerThanSecondVersion);
    }

    @Override
    public List<MvnArtifactVersion> findVersionsOlderThan(MvnArtifactVersion version) throws MvnException {
        return this.findArtifactVersionsWithFilter(version, (ver, current) -> MavenCentral.isFirstVersionBiggerThanSecondVersion(current, ver));
    }

    private List<MvnArtifactVersion> findArtifactVersionsWithFilter(MvnArtifactVersion current, BiPredicate<MvnArtifactVersion, MvnArtifactVersion> predicate) throws MvnException {
        List<MvnArtifactVersion> versions = this.findVersions(current.artifact(), 0, Integer.MAX_VALUE);
        MvnArtifactVersion loaded = versions.stream().filter(ver -> ver.name().equals(current.name())).findFirst().orElse(null);
        if (loaded == null) {
            throw new IllegalStateException(String.format("Version %s was not found in Maven Central.", current.name()));
        }
        return versions.stream().filter(ver -> predicate.test((MvnArtifactVersion)ver, loaded)).collect(Collectors.toList());
    }

    private static List<JSONObject> parseResponse(String response) throws ParseException {
        return new ArrayList<JSONObject>((Collection<JSONObject>)((JSONArray)((JSONObject)((JSONObject)new JSONParser().parse(response)).get((Object)"response")).get((Object)"docs")));
    }

    private static Boolean isFirstVersionBiggerThanSecondVersion(MvnArtifactVersion first, MvnArtifactVersion second) {
        return ModuleDescriptor.Version.parse(first.name()).compareTo(ModuleDescriptor.Version.parse(second.name())) > 0;
    }
}

