/*
 * Decompiled with CFR 0.152.
 */
package com.github.aistomin.maven.browser;

import com.github.aistomin.maven.browser.MvnArtifact;
import com.github.aistomin.maven.browser.MvnArtifactVersion;
import com.github.aistomin.maven.browser.MvnDependency;

public final class MavenDependency
implements MvnDependency {
    private final MvnArtifactVersion ver;

    public MavenDependency(MvnArtifactVersion version) {
        this.ver = version;
    }

    @Override
    public String forMaven() {
        MvnArtifact artifact = this.ver.artifact();
        return String.format("<dependency>%n%s%n%s%n%s%n</dependency>", String.format("  <groupId>%s</groupId>", artifact.group().name()), String.format("  <artifactId>%s</artifactId>", artifact.name()), String.format("  <version>%s</version>", this.ver.name()));
    }

    @Override
    public String forBuildr() {
        MvnArtifact artifact = this.ver.artifact();
        return String.format("'%s:%s:jar:%s'", artifact.group().name(), artifact.name(), this.ver.name());
    }

    @Override
    public String forIvy() {
        MvnArtifact artifact = this.ver.artifact();
        return String.format("<dependency org=\"%s\" name=\"%s\" rev=\"%s\" />", artifact.group().name(), artifact.name(), this.ver.name());
    }

    @Override
    public String forGroovyGrape() {
        MvnArtifact artifact = this.ver.artifact();
        return String.format("@Grapes(%n  @Grab(group='%s', module='%s', version='%s')%n)", artifact.group().name(), artifact.name(), this.ver.name());
    }

    @Override
    public String forGradle() {
        MvnArtifact artifact = this.ver.artifact();
        return String.format("compile '%s:%s:%s'", artifact.group().name(), artifact.name(), this.ver.name());
    }

    @Override
    public String forScala() {
        MvnArtifact artifact = this.ver.artifact();
        return String.format("libraryDependencies += \"%s\" %% \"%s\" %% \"%s\"", artifact.group().name(), artifact.name(), this.ver.name());
    }

    @Override
    public String forLeiningen() {
        MvnArtifact artifact = this.ver.artifact();
        return String.format("[%s/%s \"%s\"]", artifact.group().name(), artifact.name(), this.ver.name());
    }
}

