/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.clikt.output;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010 \n\u0002\b'\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u0004\u001a\u00020\u0003H\u0016J\b\u0010\u0005\u001a\u00020\u0003H\u0016J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0016J\u0018\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0016J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003H\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\b\u0010\u000f\u001a\u00020\u0003H\u0016J\u0018\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016J\b\u0010\u0016\u001a\u00020\u0003H\u0016J\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003H\u0016J\b\u0010\u001a\u001a\u00020\u0003H\u0016J\b\u0010\u001b\u001a\u00020\u0003H\u0016J\b\u0010\u001c\u001a\u00020\u0003H\u0016J\b\u0010\u001d\u001a\u00020\u0003H\u0016J\u0018\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010 \u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003H\u0016J\b\u0010!\u001a\u00020\u0003H\u0016J\u001e\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030%H\u0016J \u0010&\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\u0003H\u0016J\u0018\u0010&\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0016J\u0010\u0010(\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u001e\u0010)\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030%H\u0016J\u0010\u0010*\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0010\u0010+\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u001e\u0010,\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00030%H\u0016J\u001e\u0010.\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00030%H\u0016J\u001e\u00100\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00030%H\u0016J\b\u00101\u001a\u00020\u0003H\u0016J\b\u00102\u001a\u00020\u0003H\u0016J\u0018\u00103\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u0003H\u0016J\u0018\u00106\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u0003H\u0016J\u0018\u00107\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u0003H\u0016J\u0018\u00108\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u0003H\u0016J\u0018\u00109\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u0003H\u0016J\u0018\u0010:\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u0003H\u0016J\b\u0010;\u001a\u00020\u0003H\u0016J\b\u0010<\u001a\u00020\u0003H\u0016J\b\u0010=\u001a\u00020\u0003H\u0016J\b\u0010>\u001a\u00020\u0003H\u0016J \u0010?\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010@\u001a\u00020\u00032\u0006\u0010A\u001a\u00020\u0003H\u0016J\u0018\u0010B\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010C\u001a\u00020\u0003H\u0016J\u0018\u0010D\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010C\u001a\u00020\u0003H\u0016J\u0010\u0010E\u001a\u00020\u00032\u0006\u0010F\u001a\u00020\u0003H\u0016J\b\u0010G\u001a\u00020\u0003H\u0016J\b\u0010H\u001a\u00020\u0003H\u0016J\b\u0010I\u001a\u00020\u0003H\u0016J\u0010\u0010J\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0016J\b\u0010K\u001a\u00020\u0003H\u0016\u00a8\u0006L"}, d2={"Lcom/github/ajalt/clikt/output/Localization;", "", "aborted", "", "argumentsTitle", "badParameter", "badParameterWithMessage", "message", "badParameterWithMessageAndParam", "paramName", "badParameterWithParam", "boolConversionError", "value", "commandMetavar", "commandsTitle", "defaultMetavar", "extraArgumentMany", "name", "count", "", "extraArgumentOne", "fileEndsWithSlash", "fileMetavar", "fileNotFound", "filename", "floatConversionError", "floatMetavar", "helpOptionMessage", "helpTagDefault", "helpTagRequired", "incorrectArgumentValueCount", "incorrectOptionValueCount", "intConversionError", "intMetavar", "invalidChoice", "choice", "choices", "", "invalidFileFormat", "lineNumber", "invalidFlagValueInFile", "invalidGroupChoice", "missingArgument", "missingOption", "mutexGroupException", "others", "noSuchOption", "possibilities", "noSuchSubcommand", "optionsMetavar", "optionsTitle", "pathDoesNotExist", "pathType", "path", "pathIsDirectory", "pathIsFile", "pathIsNotReadable", "pathIsNotWritable", "pathIsSymlink", "pathMetavar", "pathTypeDirectory", "pathTypeFile", "pathTypeOther", "rangeExceededBoth", "min", "max", "rangeExceededMax", "limit", "rangeExceededMin", "requiredMutexOption", "options", "stringMetavar", "switchOptionEnvvar", "unclosedQuote", "usageError", "usageTitle", "clikt"})
public interface Localization {
    @NotNull
    public String aborted();

    @NotNull
    public String usageError(@NotNull String var1);

    @NotNull
    public String badParameter();

    @NotNull
    public String badParameterWithMessage(@NotNull String var1);

    @NotNull
    public String badParameterWithParam(@NotNull String var1);

    @NotNull
    public String badParameterWithMessageAndParam(@NotNull String var1, @NotNull String var2);

    @NotNull
    public String missingOption(@NotNull String var1);

    @NotNull
    public String missingArgument(@NotNull String var1);

    @NotNull
    public String noSuchSubcommand(@NotNull String var1, @NotNull List<String> var2);

    @NotNull
    public String noSuchOption(@NotNull String var1, @NotNull List<String> var2);

    @NotNull
    public String incorrectOptionValueCount(@NotNull String var1, int var2);

    @NotNull
    public String incorrectArgumentValueCount(@NotNull String var1, int var2);

    @NotNull
    public String mutexGroupException(@NotNull String var1, @NotNull List<String> var2);

    @NotNull
    public String fileNotFound(@NotNull String var1);

    @NotNull
    public String invalidFileFormat(@NotNull String var1, @NotNull String var2);

    @NotNull
    public String invalidFileFormat(@NotNull String var1, int var2, @NotNull String var3);

    @NotNull
    public String unclosedQuote();

    @NotNull
    public String fileEndsWithSlash();

    @NotNull
    public String extraArgumentOne(@NotNull String var1);

    @NotNull
    public String extraArgumentMany(@NotNull String var1, int var2);

    @NotNull
    public String invalidFlagValueInFile(@NotNull String var1);

    @NotNull
    public String switchOptionEnvvar();

    @NotNull
    public String requiredMutexOption(@NotNull String var1);

    @NotNull
    public String invalidGroupChoice(@NotNull String var1, @NotNull List<String> var2);

    @NotNull
    public String floatConversionError(@NotNull String var1);

    @NotNull
    public String intConversionError(@NotNull String var1);

    @NotNull
    public String boolConversionError(@NotNull String var1);

    @NotNull
    public String rangeExceededMax(@NotNull String var1, @NotNull String var2);

    @NotNull
    public String rangeExceededMin(@NotNull String var1, @NotNull String var2);

    @NotNull
    public String rangeExceededBoth(@NotNull String var1, @NotNull String var2, @NotNull String var3);

    @NotNull
    public String invalidChoice(@NotNull String var1, @NotNull List<String> var2);

    @NotNull
    public String pathTypeFile();

    @NotNull
    public String pathTypeDirectory();

    @NotNull
    public String pathTypeOther();

    @NotNull
    public String pathDoesNotExist(@NotNull String var1, @NotNull String var2);

    @NotNull
    public String pathIsFile(@NotNull String var1, @NotNull String var2);

    @NotNull
    public String pathIsDirectory(@NotNull String var1, @NotNull String var2);

    @NotNull
    public String pathIsNotWritable(@NotNull String var1, @NotNull String var2);

    @NotNull
    public String pathIsNotReadable(@NotNull String var1, @NotNull String var2);

    @NotNull
    public String pathIsSymlink(@NotNull String var1, @NotNull String var2);

    @NotNull
    public String defaultMetavar();

    @NotNull
    public String stringMetavar();

    @NotNull
    public String floatMetavar();

    @NotNull
    public String intMetavar();

    @NotNull
    public String pathMetavar();

    @NotNull
    public String fileMetavar();

    @NotNull
    public String usageTitle();

    @NotNull
    public String optionsTitle();

    @NotNull
    public String argumentsTitle();

    @NotNull
    public String commandsTitle();

    @NotNull
    public String optionsMetavar();

    @NotNull
    public String commandMetavar();

    @NotNull
    public String helpTagDefault();

    @NotNull
    public String helpTagRequired();

    @NotNull
    public String helpOptionMessage();

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static String aborted(@NotNull Localization this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return "Aborted!";
        }

        @NotNull
        public static String usageError(@NotNull Localization this_, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return Intrinsics.stringPlus((String)"Error: ", (Object)message);
        }

        @NotNull
        public static String badParameter(@NotNull Localization this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return "Invalid value";
        }

        @NotNull
        public static String badParameterWithMessage(@NotNull Localization this_, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return Intrinsics.stringPlus((String)"Invalid value: ", (Object)message);
        }

        @NotNull
        public static String badParameterWithParam(@NotNull Localization this_, @NotNull String paramName) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)paramName, (String)"paramName");
            return "Invalid value for \"" + paramName + '\"';
        }

        @NotNull
        public static String badParameterWithMessageAndParam(@NotNull Localization this_, @NotNull String paramName, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)paramName, (String)"paramName");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return "Invalid value for \"" + paramName + "\": " + message;
        }

        @NotNull
        public static String missingOption(@NotNull Localization this_, @NotNull String paramName) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)paramName, (String)"paramName");
            return "Missing option \"" + paramName + '\"';
        }

        @NotNull
        public static String missingArgument(@NotNull Localization this_, @NotNull String paramName) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)paramName, (String)"paramName");
            return "Missing argument \"" + paramName + '\"';
        }

        @NotNull
        public static String noSuchSubcommand(@NotNull Localization this_, @NotNull String name, @NotNull List<String> possibilities) {
            String string;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(possibilities, (String)"possibilities");
            StringBuilder stringBuilder = new StringBuilder().append("no such subcommand: \"").append(name).append('\"');
            int n = possibilities.size();
            switch (n) {
                case 0: {
                    string = "";
                    break;
                }
                case 1: {
                    string = ". Did you mean \"" + possibilities.get(0) + "\"?";
                    break;
                }
                default: {
                    string = CollectionsKt.joinToString$default((Iterable)possibilities, null, (CharSequence)". (Possible subcommands: ", (CharSequence)")", (int)0, null, null, (int)57, null);
                }
            }
            return stringBuilder.append(string).toString();
        }

        @NotNull
        public static String noSuchOption(@NotNull Localization this_, @NotNull String name, @NotNull List<String> possibilities) {
            String string;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(possibilities, (String)"possibilities");
            StringBuilder stringBuilder = new StringBuilder().append("no such option: \"").append(name).append('\"');
            int n = possibilities.size();
            switch (n) {
                case 0: {
                    string = "";
                    break;
                }
                case 1: {
                    string = ". Did you mean \"" + possibilities.get(0) + "\"?";
                    break;
                }
                default: {
                    string = CollectionsKt.joinToString$default((Iterable)possibilities, null, (CharSequence)". (Possible options: ", (CharSequence)")", (int)0, null, null, (int)57, null);
                }
            }
            return stringBuilder.append(string).toString();
        }

        @NotNull
        public static String incorrectOptionValueCount(@NotNull Localization this_, @NotNull String name, int count) {
            String string;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            int n = count;
            switch (n) {
                case 0: {
                    string = "option " + name + " does not take a value";
                    break;
                }
                case 1: {
                    string = "option " + name + " requires a value";
                    break;
                }
                default: {
                    string = "option " + name + " requires " + count + " values";
                }
            }
            return string;
        }

        @NotNull
        public static String incorrectArgumentValueCount(@NotNull Localization this_, @NotNull String name, int count) {
            String string;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            int n = count;
            switch (n) {
                case 0: {
                    string = "argument " + name + " does not take a value";
                    break;
                }
                case 1: {
                    string = "argument " + name + " requires a value";
                    break;
                }
                default: {
                    string = "argument " + name + " requires " + count + " values";
                }
            }
            return string;
        }

        @NotNull
        public static String mutexGroupException(@NotNull Localization this_, @NotNull String name, @NotNull List<String> others) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(others, (String)"others");
            return "option " + name + " cannot be used with " + CollectionsKt.joinToString$default((Iterable)others, (CharSequence)" or ", null, null, (int)0, null, null, (int)62, null);
        }

        @NotNull
        public static String fileNotFound(@NotNull Localization this_, @NotNull String filename) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
            return Intrinsics.stringPlus((String)filename, (Object)" not found");
        }

        @NotNull
        public static String invalidFileFormat(@NotNull Localization this_, @NotNull String filename, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return "incorrect format in file " + filename + ": " + message;
        }

        @NotNull
        public static String invalidFileFormat(@NotNull Localization this_, @NotNull String filename, int lineNumber, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return "incorrect format in file " + filename + " line " + lineNumber + ": " + message;
        }

        @NotNull
        public static String unclosedQuote(@NotNull Localization this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return "unclosed quote";
        }

        @NotNull
        public static String fileEndsWithSlash(@NotNull Localization this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return "file ends with \\";
        }

        @NotNull
        public static String extraArgumentOne(@NotNull Localization this_, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return Intrinsics.stringPlus((String)"Got unexpected extra argument ", (Object)name);
        }

        @NotNull
        public static String extraArgumentMany(@NotNull Localization this_, @NotNull String name, int count) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return Intrinsics.stringPlus((String)"Got unexpected extra arguments ", (Object)name);
        }

        @NotNull
        public static String invalidFlagValueInFile(@NotNull Localization this_, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return Intrinsics.stringPlus((String)"Invalid flag value in file for option ", (Object)name);
        }

        @NotNull
        public static String switchOptionEnvvar(@NotNull Localization this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return "environment variables not supported for switch options";
        }

        @NotNull
        public static String requiredMutexOption(@NotNull Localization this_, @NotNull String options) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            return Intrinsics.stringPlus((String)"Must provide one of ", (Object)options);
        }

        @NotNull
        public static String invalidGroupChoice(@NotNull Localization this_, @NotNull String value, @NotNull List<String> choices) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter(choices, (String)"choices");
            return "invalid choice: " + value + ". (choose from " + CollectionsKt.joinToString$default((Iterable)choices, null, null, null, (int)0, null, null, (int)63, null) + ')';
        }

        @NotNull
        public static String floatConversionError(@NotNull Localization this_, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Intrinsics.stringPlus((String)value, (Object)" is not a valid floating point value");
        }

        @NotNull
        public static String intConversionError(@NotNull Localization this_, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Intrinsics.stringPlus((String)value, (Object)" is not a valid integer");
        }

        @NotNull
        public static String boolConversionError(@NotNull Localization this_, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Intrinsics.stringPlus((String)value, (Object)" is not a valid boolean");
        }

        @NotNull
        public static String rangeExceededMax(@NotNull Localization this_, @NotNull String value, @NotNull String limit) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)limit, (String)"limit");
            return value + " is larger than the maximum valid value of " + limit + '.';
        }

        @NotNull
        public static String rangeExceededMin(@NotNull Localization this_, @NotNull String value, @NotNull String limit) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)limit, (String)"limit");
            return value + " is smaller than the minimum valid value of " + limit + '.';
        }

        @NotNull
        public static String rangeExceededBoth(@NotNull Localization this_, @NotNull String value, @NotNull String min, @NotNull String max) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)min, (String)"min");
            Intrinsics.checkNotNullParameter((Object)max, (String)"max");
            return value + " is not in the valid range of " + min + " to " + max + '.';
        }

        @NotNull
        public static String invalidChoice(@NotNull Localization this_, @NotNull String choice, @NotNull List<String> choices) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)choice, (String)"choice");
            Intrinsics.checkNotNullParameter(choices, (String)"choices");
            return "invalid choice: " + choice + ". (choose from " + CollectionsKt.joinToString$default((Iterable)choices, null, null, null, (int)0, null, null, (int)63, null) + ')';
        }

        @NotNull
        public static String pathTypeFile(@NotNull Localization this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return "File";
        }

        @NotNull
        public static String pathTypeDirectory(@NotNull Localization this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return "Directory";
        }

        @NotNull
        public static String pathTypeOther(@NotNull Localization this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return "Path";
        }

        @NotNull
        public static String pathDoesNotExist(@NotNull Localization this_, @NotNull String pathType, @NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)pathType, (String)"pathType");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            return pathType + " \"" + path2 + "\" does not exist.";
        }

        @NotNull
        public static String pathIsFile(@NotNull Localization this_, @NotNull String pathType, @NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)pathType, (String)"pathType");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            return pathType + " \"" + path2 + "\" is a file.";
        }

        @NotNull
        public static String pathIsDirectory(@NotNull Localization this_, @NotNull String pathType, @NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)pathType, (String)"pathType");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            return pathType + " \"" + path2 + "\" is a directory.";
        }

        @NotNull
        public static String pathIsNotWritable(@NotNull Localization this_, @NotNull String pathType, @NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)pathType, (String)"pathType");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            return pathType + " \"" + path2 + "\" is not writable.";
        }

        @NotNull
        public static String pathIsNotReadable(@NotNull Localization this_, @NotNull String pathType, @NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)pathType, (String)"pathType");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            return pathType + " \"" + path2 + "\" is not readable.";
        }

        @NotNull
        public static String pathIsSymlink(@NotNull Localization this_, @NotNull String pathType, @NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)pathType, (String)"pathType");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            return pathType + " \"" + path2 + "\" is a symlink.";
        }

        @NotNull
        public static String defaultMetavar(@NotNull Localization this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return "VALUE";
        }

        @NotNull
        public static String stringMetavar(@NotNull Localization this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return "TEXT";
        }

        @NotNull
        public static String floatMetavar(@NotNull Localization this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return "FLOAT";
        }

        @NotNull
        public static String intMetavar(@NotNull Localization this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return "INT";
        }

        @NotNull
        public static String pathMetavar(@NotNull Localization this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return "PATH";
        }

        @NotNull
        public static String fileMetavar(@NotNull Localization this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return "FILE";
        }

        @NotNull
        public static String usageTitle(@NotNull Localization this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return "Usage:";
        }

        @NotNull
        public static String optionsTitle(@NotNull Localization this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return "Options:";
        }

        @NotNull
        public static String argumentsTitle(@NotNull Localization this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return "Arguments:";
        }

        @NotNull
        public static String commandsTitle(@NotNull Localization this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return "Commands:";
        }

        @NotNull
        public static String optionsMetavar(@NotNull Localization this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return "[OPTIONS]";
        }

        @NotNull
        public static String commandMetavar(@NotNull Localization this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return "COMMAND [ARGS]...";
        }

        @NotNull
        public static String helpTagDefault(@NotNull Localization this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return "default";
        }

        @NotNull
        public static String helpTagRequired(@NotNull Localization this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return "required";
        }

        @NotNull
        public static String helpOptionMessage(@NotNull Localization this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return "Show this message and exit";
        }
    }
}

