/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.clikt.output;

import com.github.ajalt.clikt.output.TextKt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u001a\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0000\u001a(\u0010\r\u001a\u00020\u000e*\u00060\u000fj\u0002`\u00102\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0002\u001a0\u0010\u0013\u001a\u00020\u0014*\u00060\u000fj\u0002`\u00102\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0002\u001a6\u0010\u0017\u001a\u00020\u0014*\u00020\u00032\n\u0010\u0018\u001a\u00060\u000fj\u0002`\u00102\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0011\u001a\u00020\u00032\b\b\u0002\u0010\u0012\u001a\u00020\u0003H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"LINE_BREAK_REGEX", "Lkotlin/text/Regex;", "NEL", "", "PLAIN_P_END_REGEX", "PRE_P_CONTENTS_REGEX", "PRE_P_END_REGEX", "TEXT_START_REGEX", "WHITESPACE_OR_NEL_REGEX", "WORD_OR_NEL_REGEX", "splitParagraphs", "", "text", "tryPreformat", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "initialIndent", "subsequentIndent", "wrapParagraph", "", "width", "", "wrapText", "sb", "clikt"})
public final class TextKt {
    @NotNull
    public static final String NEL = "\u0085";
    @NotNull
    private static final Regex TEXT_START_REGEX = new Regex("\\S");
    @NotNull
    private static final Regex PRE_P_END_REGEX = new Regex("```[ \\t]*(?:\\n\\s*|[ \\t]*$)");
    @NotNull
    private static final Regex PLAIN_P_END_REGEX = new Regex("[ \\t]*\\n(?:\\s*```|[ \\t]*\\n\\s*)|\u0085?\\s*$");
    @NotNull
    private static final Regex LINE_BREAK_REGEX = new Regex("\r?\n");
    @NotNull
    private static final Regex WHITESPACE_OR_NEL_REGEX = new Regex("\\s+|\u0085");
    @NotNull
    private static final Regex WORD_OR_NEL_REGEX = new Regex("[^\\s\u0085]+|\u0085");
    @NotNull
    private static final Regex PRE_P_CONTENTS_REGEX = new Regex("```([\\s\\S]*?)```");

    public static final void wrapText(@NotNull String $this$wrapText, @NotNull StringBuilder sb, int width, @NotNull String initialIndent, @NotNull String subsequentIndent) {
        Intrinsics.checkNotNullParameter((Object)$this$wrapText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
        Intrinsics.checkNotNullParameter((Object)initialIndent, (String)"initialIndent");
        Intrinsics.checkNotNullParameter((Object)subsequentIndent, (String)"subsequentIndent");
        boolean bl = initialIndent.length() < width;
        int n = 0;
        boolean bl2 = false;
        if (!bl) {
            boolean bl3 = false;
            String string = "initialIndent >= width: " + initialIndent.length() + " >= " + width;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = subsequentIndent.length() < width;
        n = 0;
        bl2 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "subsequentIndent >= width: " + subsequentIndent.length() + " >= " + width;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Iterator<String> iterator = TextKt.splitParagraphs($this$wrapText).iterator();
        n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            String paragraph = iterator.next();
            if (i > 0) {
                sb.append("\n\n");
            }
            TextKt.wrapParagraph(sb, paragraph, width, i == 0 ? initialIndent : subsequentIndent, subsequentIndent);
        }
    }

    public static /* synthetic */ void wrapText$default(String string, StringBuilder stringBuilder, int n, String string2, String string3, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 78;
        }
        if ((n2 & 4) != 0) {
            string2 = "";
        }
        if ((n2 & 8) != 0) {
            string3 = "";
        }
        TextKt.wrapText(string, stringBuilder, n, string2, string3);
    }

    @NotNull
    public static final List<String> splitParagraphs(@NotNull String text) {
        Object object;
        Integer n;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        boolean bl = false;
        List paragraphs = new ArrayList();
        Object object2 = Regex.find$default((Regex)TEXT_START_REGEX, (CharSequence)text, (int)0, (int)2, null);
        Integer n2 = object2 == null ? null : (n = (object = object2.getRange()) == null ? null : Integer.valueOf(object.getFirst()));
        if (n == null) {
            return CollectionsKt.emptyList();
        }
        int i = n;
        while (i < text.length()) {
            IntRange it;
            boolean bl2;
            boolean bl3;
            IntRange intRange;
            if (StringsKt.startsWith$default((String)text, (String)"```", (int)i, (boolean)false, (int)4, null)) {
                object = PRE_P_END_REGEX.find((CharSequence)text, i + 3);
                if (object == null) {
                    intRange = null;
                } else {
                    IntRange intRange2 = object;
                    bl3 = false;
                    bl2 = false;
                    it = intRange2;
                    boolean bl4 = false;
                    intRange = new IntRange(it.getRange().getFirst() + 3, it.getRange().getLast());
                }
            } else {
                object = PLAIN_P_END_REGEX.find((CharSequence)text, i);
                if (object == null) {
                    intRange = null;
                } else {
                    IntRange intRange3 = object;
                    bl3 = false;
                    bl2 = false;
                    it = intRange3;
                    boolean bl5 = false;
                    intRange = StringsKt.startsWith$default((String)it.getValue(), (String)NEL, (boolean)false, (int)2, null) ? new IntRange(it.getRange().getFirst() + 1, it.getRange().getFirst() + 1) : (StringsKt.endsWith$default((String)it.getValue(), (String)"```", (boolean)false, (int)2, null) ? new IntRange(it.getRange().getFirst(), it.getRange().getLast() - 3) : it.getRange());
                }
            }
            object2 = intRange;
            MatchResult range = object2 == null ? new IntRange(text.length(), text.length()) : object2;
            object2 = paragraphs;
            object = text;
            int n3 = range.getFirst();
            bl3 = false;
            String string = ((String)object).substring(i, n3);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            object = string;
            n3 = 0;
            object2.add(object);
            i = range.getLast() + 1;
        }
        return paragraphs;
    }

    private static final boolean tryPreformat(StringBuilder $this$tryPreformat, String text, String initialIndent, String subsequentIndent) {
        String string;
        Object object;
        Object object2;
        MatchGroup value;
        MatchResult matchResult = PRE_P_CONTENTS_REGEX.matchEntire((CharSequence)text);
        object = value = matchResult == null ? null : ((object2 = matchResult.getGroups()) == null ? null : ((object = object2.get(1)) == null ? null : object.getValue()));
        Object object3 = object == null ? null : (object2 = (string = StringsKt.replaceIndent((String)object, (String)subsequentIndent)) == null ? null : StringsKt.removePrefix((String)string, (CharSequence)subsequentIndent));
        if (object2 == null) {
            return false;
        }
        MatchGroupCollection pre = object2;
        object = (CharSequence)pre;
        string = LINE_BREAK_REGEX;
        int n = 0;
        boolean bl = false;
        object2 = string.split((CharSequence)object, n).iterator();
        int n2 = 0;
        while (object2.hasNext()) {
            int i = n2++;
            String line = (String)object2.next();
            if (i == 0) {
                $this$tryPreformat.append(initialIndent);
            } else {
                $this$tryPreformat.append("\n");
            }
            String string2 = line;
            boolean bl2 = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            $this$tryPreformat.append(((Object)StringsKt.trimEnd((CharSequence)string3)).toString());
        }
        return true;
    }

    private static final void wrapParagraph(StringBuilder $this$wrapParagraph, String text, int width, String initialIndent, String subsequentIndent) {
        if (TextKt.tryPreformat($this$wrapParagraph, text, initialIndent, subsequentIndent)) {
            return;
        }
        String breakLine = Intrinsics.stringPlus((String)"\n", (Object)subsequentIndent);
        if (initialIndent.length() + text.length() <= width) {
            CharSequence charSequence = text;
            boolean bl = false;
            String string = charSequence;
            if (string == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            charSequence = ((Object)StringsKt.trim((CharSequence)string)).toString();
            Regex regex = WHITESPACE_OR_NEL_REGEX;
            Function1 function1 = (Function1)new Function1<MatchResult, CharSequence>(breakLine){
                final /* synthetic */ String $breakLine;
                {
                    this.$breakLine = $breakLine;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull MatchResult it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it.getValue(), (Object)"\u0085") ? (CharSequence)this.$breakLine : (CharSequence)" ";
                }
            };
            boolean bl2 = false;
            String newText2 = regex.replace(charSequence, function1);
            $this$wrapParagraph.append(initialIndent).append(newText2);
            return;
        }
        List words2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)WORD_OR_NEL_REGEX, (CharSequence)text, (int)0, (int)2, null), (Function1)wrapParagraph.words.1.INSTANCE));
        $this$wrapParagraph.append(initialIndent);
        int currentWidth = initialIndent.length();
        boolean prevWasNel = false;
        Iterator iterator = words2.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            String word = (String)iterator.next();
            if (Intrinsics.areEqual((Object)word, (Object)NEL)) {
                $this$wrapParagraph.append(breakLine);
                currentWidth = subsequentIndent.length();
                prevWasNel = true;
                continue;
            }
            if (i > 0 && !prevWasNel) {
                if (currentWidth + word.length() + 1 > width) {
                    $this$wrapParagraph.append(breakLine);
                    currentWidth = subsequentIndent.length();
                } else {
                    $this$wrapParagraph.append(" ");
                    ++currentWidth;
                }
            }
            prevWasNel = false;
            $this$wrapParagraph.append(word);
            currentWidth += word.length();
        }
    }
}

