/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.clikt.output;

import com.github.ajalt.clikt.core.CliktError;
import com.github.ajalt.clikt.output.Editor;
import com.github.ajalt.clikt.output.EditorKt;
import com.github.ajalt.clikt.output.JvmEditor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B3\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J#\u0010\u000f\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\u0006\u0010\u000e\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0002\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0003H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/github/ajalt/clikt/output/JvmEditor;", "Lcom/github/ajalt/clikt/output/Editor;", "editorPath", "", "env", "", "requireSave", "", "extension", "(Ljava/lang/String;Ljava/util/Map;ZLjava/lang/String;)V", "edit", "text", "editFile", "", "filename", "editFileWithEditor", "editorCmd", "", "([Ljava/lang/String;Ljava/lang/String;)V", "getEditorCommand", "()[Ljava/lang/String;", "getEditorPath", "clikt"})
@SourceDebugExtension(value={"SMAP\nEditorJVM.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorJVM.kt\ncom/github/ajalt/clikt/output/JvmEditor\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,84:1\n37#2,2:85\n*S KotlinDebug\n*F\n+ 1 EditorJVM.kt\ncom/github/ajalt/clikt/output/JvmEditor\n*L\n40#1:85,2\n*E\n"})
final class JvmEditor
implements Editor {
    @Nullable
    private final String editorPath;
    @NotNull
    private final Map<String, String> env;
    private final boolean requireSave;
    @NotNull
    private final String extension;

    public JvmEditor(@Nullable String editorPath, @NotNull Map<String, String> env, boolean requireSave, @NotNull String extension) {
        Intrinsics.checkNotNullParameter(env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        this.editorPath = editorPath;
        this.env = env;
        this.requireSave = requireSave;
        this.extension = extension;
    }

    private final String getEditorPath() {
        String string = this.editorPath;
        if (string == null) {
            string = EditorKt.inferEditorPath((Function1<? super String, Boolean>)((Function1)getEditorPath.1.INSTANCE));
        }
        return string;
    }

    private final String[] getEditorCommand() {
        String[] stringArray = new String[]{" "};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)this.getEditorPath())).toString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    private final void editFileWithEditor(String[] editorCmd, String filename) {
        try {
            Object object = new SpreadBuilder(2);
            object.addSpread((Object)editorCmd);
            object.add((Object)filename);
            Object $this$editFileWithEditor_u24lambda_u240 = object = new ProcessBuilder((String[])object.toArray((Object[])new String[object.size()]));
            boolean bl = false;
            Map<String, String> map = ((ProcessBuilder)$this$editFileWithEditor_u24lambda_u240).environment();
            Intrinsics.checkNotNullExpressionValue(map, (String)"environment(...)");
            Map<String, String> map2 = map;
            map2.putAll(this.env);
            ((ProcessBuilder)$this$editFileWithEditor_u24lambda_u240).inheritIO();
            Process process = ((ProcessBuilder)object).start();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new CliktError(editorCmd[0] + ": Editing failed!", null, 0, false, 14, null);
            }
        }
        catch (Exception err) {
            if (err instanceof CliktError) {
                throw err;
            }
            throw new CliktError("Error staring editor", err, 0, false, 12, null);
        }
    }

    @Override
    public void editFile(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        this.editFileWithEditor(this.getEditorCommand(), filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String edit(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String[] editorCmd = this.getEditorCommand();
        String textToEdit = EditorKt.normalizeEditorText(editorCmd[0], text);
        String string = this.extension;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path2 = Files.createTempFile(null, string, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"createTempFile(...)");
        Path file2 = path2;
        try {
            PathsKt.writeText$default((Path)file2, (CharSequence)textToEdit, null, (OpenOption[])new OpenOption[0], (int)2, null);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            FileTime fileTime = Files.getLastModifiedTime(file2, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"getLastModifiedTime(...)");
            FileTime ts = fileTime;
            this.editFileWithEditor(editorCmd, ((Object)file2.toAbsolutePath()).toString());
            if (this.requireSave) {
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                FileTime fileTime2 = Files.getLastModifiedTime(file2, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length));
                Intrinsics.checkNotNullExpressionValue((Object)fileTime2, (String)"getLastModifiedTime(...)");
                if (Intrinsics.areEqual((Object)fileTime2, (Object)ts)) {
                    string = null;
                    return string;
                }
            }
            string = StringsKt.replace$default((String)PathsKt.readText$default((Path)file2, null, (int)1, null), (String)"\r\n", (String)"\n", (boolean)false, (int)4, null);
            return string;
        }
        catch (Exception err) {
            throw new CliktError("Error staring editor", err, 0, false, 12, null);
        }
        finally {
            Files.deleteIfExists(file2);
        }
    }
}

