/*
 * Decompiled with CFR 0.152.
 */
package pl.jozwik.smtp.server;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.OutHandler;
import org.apache.pekko.stream.stage.TimerGraphStageLogic;
import pl.jozwik.smtp.server.AddressHandler;
import pl.jozwik.smtp.server.Errors$;
import pl.jozwik.smtp.server.MailAccumulator;
import pl.jozwik.smtp.server.MailAccumulator$;
import pl.jozwik.smtp.server.MultiLineResponse;
import pl.jozwik.smtp.server.NoDataResponse$;
import pl.jozwik.smtp.server.NoResponse$;
import pl.jozwik.smtp.server.QuitResponse;
import pl.jozwik.smtp.server.ResponseMessage;
import pl.jozwik.smtp.server.SmtpTimerGraphStageLogic$;
import pl.jozwik.smtp.server.TextResponse;
import pl.jozwik.smtp.server.TickTimeout$;
import pl.jozwik.smtp.server.command.MessageHandler;
import pl.jozwik.smtp.util.Constants$;
import pl.jozwik.smtp.util.ConsumedResult;
import pl.jozwik.smtp.util.FailedConsumed;
import pl.jozwik.smtp.util.Mail;
import pl.jozwik.smtp.util.SizeParameterHandler;
import pl.jozwik.smtp.util.SuccessfulConsumed$;
import pl.jozwik.smtp.util.Utils$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005x!B\u000e\u001d\u0011\u0003)c!B\u0014\u001d\u0011\u0003A\u0003\"B\u0018\u0002\t\u0003\u0001\u0004bB\u0019\u0002\u0005\u0004%IA\r\u0005\u0007w\u0005\u0001\u000b\u0011B\u001a\u0007\t\u001db\u0002\u0001\u0010\u0005\t+\u0016\u0011\t\u0011)A\u0005-\"AQ-\u0002B\u0001B\u0003%a\r\u0003\u0005j\u000b\t\u0005\t\u0015!\u0003k\u0011!\u0001XA!A!\u0002\u0013Q\u0006\u0002C9\u0006\u0005\u0003\u0005\u000b\u0011\u0002:\t\u0011i,!\u0011!Q\u0001\nmD\u0011\"!\u0005\u0006\u0005\u0003\u0005\u000b\u0011B\u001a\t\u0015\u0005MQA!A!\u0002\u0017\t)\u0002\u0003\u00040\u000b\u0011\u0005\u0011\u0011\u0005\u0005\n\u0003o)!\u0019!C\u0005\u0003sA\u0001\"!\u0015\u0006A\u0003%\u00111\b\u0005\n\u0003'*!\u0019!C\u0005\u0003+B\u0001\"a\u0019\u0006A\u0003%\u0011q\u000b\u0005\b\u0003K*A\u0011IA4\u0011\u001d\ty'\u0002C)\u0003cBq!! \u0006\t\u0013\ty\bC\u0004\u0002\"\u0016!I!a)\t\u000f\u0005EV\u0001\"\u0003\u00024\"9\u00111X\u0003\u0005\n\u0005u\u0006bBAh\u000b\u0011%\u0011\u0011\u001b\u0005\b\u00037,A\u0011BAo\u0003a\u0019V\u000e\u001e9US6,'o\u0012:ba\"\u001cF/Y4f\u0019><\u0017n\u0019\u0006\u0003;y\taa]3sm\u0016\u0014(BA\u0010!\u0003\u0011\u0019X\u000e\u001e9\u000b\u0005\u0005\u0012\u0013A\u00026pu^L7NC\u0001$\u0003\t\u0001Hn\u0001\u0001\u0011\u0005\u0019\nQ\"\u0001\u000f\u00031MkG\u000f\u001d+j[\u0016\u0014xI]1qQN#\u0018mZ3M_\u001eL7m\u0005\u0002\u0002SA\u0011!&L\u0007\u0002W)\tA&A\u0003tG\u0006d\u0017-\u0003\u0002/W\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u0013\u0002\u0017%kU*\u0012#J\u0003R+E*W\u000b\u0002gA\u0011A'O\u0007\u0002k)\u0011agN\u0001\tIV\u0014\u0018\r^5p]*\u0011\u0001hK\u0001\u000bG>t7-\u001e:sK:$\u0018B\u0001\u001e6\u000591\u0015N\\5uK\u0012+(/\u0019;j_:\fA\"S'N\u000b\u0012K\u0015\tV#M3\u0002\u001a2!B\u001fL!\tq\u0014*D\u0001@\u0015\t\u0001\u0015)A\u0003ti\u0006<WM\u0003\u0002C\u0007\u000611\u000f\u001e:fC6T!\u0001R#\u0002\u000bA,7n[8\u000b\u0005\u0019;\u0015AB1qC\u000eDWMC\u0001I\u0003\ry'oZ\u0005\u0003\u0015~\u0012A\u0003V5nKJ<%/\u00199i'R\fw-\u001a'pO&\u001c\u0007C\u0001'T\u001b\u0005i%B\u0001(P\u00031\u00198-\u00197bY><w-\u001b8h\u0015\t\u0001\u0016+\u0001\u0005usB,7/\u00194f\u0015\u0005\u0011\u0016aA2p[&\u0011A+\u0014\u0002\u000e'R\u0014\u0018n\u0019;M_\u001e<\u0017N\\4\u0002\u000bMD\u0017\r]3\u0011\t]C&LW\u0007\u0002\u0003&\u0011\u0011,\u0011\u0002\n\r2|wo\u00155ba\u0016\u0004\"a\u00172\u000f\u0005q\u0003\u0007CA/,\u001b\u0005q&BA0%\u0003\u0019a$o\\8u}%\u0011\u0011mK\u0001\u0007!J,G-\u001a4\n\u0005\r$'AB*ue&twM\u0003\u0002bW\u0005q\u0011\r\u001a3sKN\u001c\b*\u00198eY\u0016\u0014\bC\u0001\u0014h\u0013\tAGD\u0001\bBI\u0012\u0014Xm]:IC:$G.\u001a:\u0002\u0017ML'0\u001a%b]\u0012dWM\u001d\t\u0003W:l\u0011\u0001\u001c\u0006\u0003[z\tA!\u001e;jY&\u0011q\u000e\u001c\u0002\u0015'&TX\rU1sC6,G/\u001a:IC:$G.\u001a:\u0002\u001b1|7-\u00197I_N$h*Y7f\u0003\u0019\u0011X-\\8uKB\u00111\u000f_\u0007\u0002i*\u0011QO^\u0001\u0004]\u0016$(\"A<\u0002\t)\fg/Y\u0005\u0003sR\u0014\u0011#\u00138fiN{7m[3u\u0003\u0012$'/Z:t\u0003!\u0019wN\\:v[\u0016\u0014\b#\u0002\u0016}}\u0006\r\u0011BA?,\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002l\u007f&\u0019\u0011\u0011\u00017\u0003\t5\u000b\u0017\u000e\u001c\t\u0007\u0003\u000b\t9!a\u0003\u000e\u0003]J1!!\u00038\u0005\u00191U\u000f^;sKB\u00191.!\u0004\n\u0007\u0005=AN\u0001\bD_:\u001cX/\\3e%\u0016\u001cX\u000f\u001c;\u0002\u0017I,\u0017\r\u001a+j[\u0016|W\u000f^\u0001\u0007gf\u001cH/Z7\u0011\t\u0005]\u0011QD\u0007\u0003\u00033Q1!a\u0007D\u0003\u0015\t7\r^8s\u0013\u0011\ty\"!\u0007\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\u001c\u000b\u0011\u0003G\tI#a\u000b\u0002.\u0005=\u0012\u0011GA\u001a\u0003k!B!!\n\u0002(A\u0011a%\u0002\u0005\b\u0003'q\u00019AA\u000b\u0011\u0015)f\u00021\u0001W\u0011\u0015)g\u00021\u0001g\u0011\u0015Ig\u00021\u0001k\u0011\u0015\u0001h\u00021\u0001[\u0011\u0015\th\u00021\u0001s\u0011\u0015Qh\u00021\u0001|\u0011\u0019\t\tB\u0004a\u0001g\u0005Y\u0011mY2v[Vd\u0017\r^8s+\t\tY\u0004\u0005\u0004\u0002>\u0005\u001d\u00131J\u0007\u0003\u0003\u007fQA!!\u0011\u0002D\u00051\u0011\r^8nS\u000eT1\u0001OA#\u0015\tig/\u0003\u0003\u0002J\u0005}\"aD!u_6L7MU3gKJ,gnY3\u0011\u0007\u0019\ni%C\u0002\u0002Pq\u0011q\"T1jY\u0006\u001b7-^7vY\u0006$xN]\u0001\rC\u000e\u001cW/\\;mCR|'\u000fI\u0001\u000f[\u0016\u001c8/Y4f\u0011\u0006tG\r\\3s+\t\t9\u0006\u0005\u0003\u0002Z\u0005}SBAA.\u0015\r\ti\u0006H\u0001\bG>lW.\u00198e\u0013\u0011\t\t'a\u0017\u0003\u001d5+7o]1hK\"\u000bg\u000e\u001a7fe\u0006yQ.Z:tC\u001e,\u0007*\u00198eY\u0016\u0014\b%\u0001\u0005q_N$8\u000b^8q)\t\tI\u0007E\u0002+\u0003WJ1!!\u001c,\u0005\u0011)f.\u001b;\u0002\u000f=tG+[7feR!\u0011\u0011NA:\u0011\u001d\t)\b\u0006a\u0001\u0003o\n!\u0001^6\u0011\u0007)\nI(C\u0002\u0002|-\u00121!\u00118z\u0003%Ig\u000eS1oI2,'\u000f\u0006\u0004\u0002\u0002\u00065\u0015q\u0013\n\u0006\u0003\u0007K\u0013q\u0011\u0004\u0007\u0003\u000b+\u0002!!!\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0011\u0007y\nI)C\u0002\u0002\f~\u0012\u0011\"\u00138IC:$G.\u001a:\t\u000f\u0005=U\u0003q\u0001\u0002\u0012\u0006\u0011\u0011N\u001c\t\u0005/\u0006M%,C\u0002\u0002\u0016\u0006\u0013Q!\u00138mKRDq!!'\u0016\u0001\b\tY*A\u0002pkR\u0004BaVAO5&\u0019\u0011qT!\u0003\r=+H\u000f\\3u\u0003)yW\u000f\u001e%b]\u0012dWM\u001d\u000b\u0005\u0003K\u000byKE\u0003\u0002(&\nIK\u0002\u0004\u0002\u0006Z\u0001\u0011Q\u0015\t\u0004}\u0005-\u0016bAAW\u007f\tQq*\u001e;IC:$G.\u001a:\t\u000f\u0005=e\u00031\u0001\u0002\u0012\u0006i\u0001.\u00198eY\u0016$\u0016.\\3pkR$B!!.\u0002:R!\u0011\u0011NA\\\u0011\u001d\tIj\u0006a\u0002\u00037Cq!!\u001e\u0018\u0001\u0004\t9(\u0001\biC:$G.\u001a*fgB|gn]3\u0015\t\u0005}\u0016Q\u0019\u000b\u0007\u0003S\n\t-a1\t\u000f\u0005=\u0005\u0004q\u0001\u0002\u0012\"9\u0011\u0011\u0014\rA\u0004\u0005m\u0005bBAd1\u0001\u0007\u0011\u0011Z\u0001\te\u0016\u001c\bo\u001c8tKB\u0019a%a3\n\u0007\u00055GDA\bSKN\u0004xN\\:f\u001b\u0016\u001c8/Y4f\u0003E\u0001Xo\u001d5XSRDWI\u001c3PM2Kg.\u001a\u000b\u0005\u0003'\f9\u000e\u0006\u0003\u0002j\u0005U\u0007bBAM3\u0001\u000f\u00111\u0014\u0005\u0007\u00033L\u0002\u0019\u0001.\u0002\u000f5,7o]1hK\u0006\t\u0002/\u001e7m\u0003:$'+Z:fiRKW.\u001a:\u0015\t\u0005%\u0014q\u001c\u0005\b\u0003\u001fS\u00029AAI\u0001")
public class SmtpTimerGraphStageLogic
extends TimerGraphStageLogic
implements StrictLogging {
    private final FlowShape<String, String> shape;
    private final String localHostName;
    private final Function1<Mail, Future<ConsumedResult>> consumer;
    private final FiniteDuration readTimeout;
    private final ActorSystem system;
    private final AtomicReference<MailAccumulator> pl$jozwik$smtp$server$SmtpTimerGraphStageLogic$$accumulator;
    private final MessageHandler pl$jozwik$smtp$server$SmtpTimerGraphStageLogic$$messageHandler;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public AtomicReference<MailAccumulator> pl$jozwik$smtp$server$SmtpTimerGraphStageLogic$$accumulator() {
        return this.pl$jozwik$smtp$server$SmtpTimerGraphStageLogic$$accumulator;
    }

    public MessageHandler pl$jozwik$smtp$server$SmtpTimerGraphStageLogic$$messageHandler() {
        return this.pl$jozwik$smtp$server$SmtpTimerGraphStageLogic$$messageHandler;
    }

    public void postStop() {
        this.cancelTimer(TickTimeout$.MODULE$);
        super.postStop();
    }

    public void onTimer(Object tk) {
        this.handleTimeout(tk, (Outlet<String>)this.shape.out());
    }

    private InHandler inHandler(Inlet<String> in, Outlet<String> out) {
        return new InHandler(this, in, out){
            private final /* synthetic */ SmtpTimerGraphStageLogic $outer;
            private final Inlet in$1;
            private final Outlet out$1;

            public void onUpstreamFinish() throws Exception {
                InHandler.onUpstreamFinish$((InHandler)this);
            }

            public void onUpstreamFailure(Throwable ex) throws Exception {
                InHandler.onUpstreamFailure$((InHandler)this, (Throwable)ex);
            }

            public void onPush() {
                String line = (String)this.$outer.grab(this.in$1);
                String stripped = StringOps$.MODULE$.stripLineEnd$extension(Predef$.MODULE$.augmentString(line));
                Tuple2<MailAccumulator, ResponseMessage> tuple2 = this.$outer.pl$jozwik$smtp$server$SmtpTimerGraphStageLogic$$messageHandler().handleMessage(line, stripped, this.$outer.pl$jozwik$smtp$server$SmtpTimerGraphStageLogic$$accumulator().get());
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                MailAccumulator acc = (MailAccumulator)tuple2._1();
                ResponseMessage response = (ResponseMessage)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)acc, (Object)response);
                MailAccumulator acc2 = (MailAccumulator)tuple22._1();
                ResponseMessage response2 = (ResponseMessage)tuple22._2();
                this.$outer.pl$jozwik$smtp$server$SmtpTimerGraphStageLogic$$handleResponse(response2, (Inlet<String>)this.in$1, (Outlet<String>)this.out$1);
                this.$outer.pl$jozwik$smtp$server$SmtpTimerGraphStageLogic$$accumulator().set(acc2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.in$1 = in$1;
                this.out$1 = out$1;
                InHandler.$init$((InHandler)this);
            }
        };
    }

    private OutHandler outHandler(Inlet<String> in) {
        return new OutHandler(this, in){
            private final /* synthetic */ SmtpTimerGraphStageLogic $outer;
            private final Inlet in$2;

            public void onDownstreamFinish() throws Exception {
                OutHandler.onDownstreamFinish$((OutHandler)this);
            }

            public void onDownstreamFinish(Throwable cause) throws Exception {
                OutHandler.onDownstreamFinish$((OutHandler)this, (Throwable)cause);
            }

            public void onPull() {
                this.$outer.pl$jozwik$smtp$server$SmtpTimerGraphStageLogic$$pullAndResetTimer((Inlet<String>)this.in$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.in$2 = in$2;
                OutHandler.$init$((OutHandler)this);
            }
        };
    }

    private void handleTimeout(Object tk, Outlet<String> out) {
        Object object = tk;
        if (SuccessfulConsumed$.MODULE$.equals(object)) {
            this.pushWithEndOfLine(Constants$.MODULE$.SMTP_OK(), out);
            return;
        }
        if (object instanceof FailedConsumed) {
            BoxedUnit boxedUnit;
            FailedConsumed failedConsumed = (FailedConsumed)object;
            String error = failedConsumed.error();
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("{}", (Object)error);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.pushWithEndOfLine(new StringBuilder(1).append(Constants$.MODULE$.TRANSACTION_FAILED()).append(" ").append(error).toString(), out);
            return;
        }
        if (TickTimeout$.MODULE$.equals(object)) {
            this.pushWithEndOfLine(Errors$.MODULE$.serviceNotAvailable(this.localHostName, this.readTimeout.toSeconds()), out);
            this.failStage(new RuntimeException("Service timeout"));
            return;
        }
        throw new UnsupportedOperationException(String.valueOf(object));
    }

    public void pl$jozwik$smtp$server$SmtpTimerGraphStageLogic$$handleResponse(ResponseMessage response, Inlet<String> in, Outlet<String> out) {
        ResponseMessage responseMessage = response;
        if (responseMessage instanceof TextResponse) {
            TextResponse textResponse = (TextResponse)responseMessage;
            String command = textResponse.message();
            this.pushWithEndOfLine(command, out);
            return;
        }
        if (NoDataResponse$.MODULE$.equals(responseMessage)) {
            this.pl$jozwik$smtp$server$SmtpTimerGraphStageLogic$$pullAndResetTimer(in);
            return;
        }
        if (responseMessage instanceof QuitResponse) {
            QuitResponse quitResponse = (QuitResponse)responseMessage;
            String command = quitResponse.message();
            this.pushWithEndOfLine(command, out);
            this.completeStage();
            return;
        }
        if (responseMessage instanceof MultiLineResponse) {
            MultiLineResponse multiLineResponse = (MultiLineResponse)responseMessage;
            Seq<String> lines = multiLineResponse.message();
            this.push(out, ((IterableOnceOps)lines.map((Function1 & Serializable)line -> Utils$.MODULE$.withEndOfLine(line))).mkString());
            return;
        }
        if (NoResponse$.MODULE$.equals(responseMessage)) {
            return;
        }
        throw new MatchError((Object)responseMessage);
    }

    private void pushWithEndOfLine(String message, Outlet<String> out) {
        this.push(out, Utils$.MODULE$.withEndOfLine(message));
    }

    public void pl$jozwik$smtp$server$SmtpTimerGraphStageLogic$$pullAndResetTimer(Inlet<String> in) {
        this.pull(in);
        this.scheduleOnce(TickTimeout$.MODULE$, this.readTimeout);
    }

    public static final /* synthetic */ void $anonfun$messageHandler$1(SmtpTimerGraphStageLogic $this, Mail mail) {
        ((Future)$this.consumer.apply((Object)mail)).foreach((Function1 & Serializable)response -> {
            $this.scheduleOnce(response, SmtpTimerGraphStageLogic$.MODULE$.pl$jozwik$smtp$server$SmtpTimerGraphStageLogic$$IMMEDIATELY());
            return BoxedUnit.UNIT;
        }, (ExecutionContext)$this.system.dispatcher());
    }

    public SmtpTimerGraphStageLogic(FlowShape<String, String> shape, AddressHandler addressHandler, SizeParameterHandler sizeHandler, String localHostName, InetSocketAddress remote, Function1<Mail, Future<ConsumedResult>> consumer, FiniteDuration readTimeout, ActorSystem system) {
        this.shape = shape;
        this.localHostName = localHostName;
        this.consumer = consumer;
        this.readTimeout = readTimeout;
        this.system = system;
        super(shape);
        StrictLogging.$init$((StrictLogging)this);
        this.pl$jozwik$smtp$server$SmtpTimerGraphStageLogic$$accumulator = new AtomicReference<MailAccumulator>(MailAccumulator$.MODULE$.empty());
        this.pl$jozwik$smtp$server$SmtpTimerGraphStageLogic$$messageHandler = new MessageHandler(addressHandler, sizeHandler, localHostName, remote, (Function1<Mail, BoxedUnit>)(Function1 & Serializable)mail -> {
            SmtpTimerGraphStageLogic.$anonfun$messageHandler$1(this, mail);
            return BoxedUnit.UNIT;
        });
        this.setHandler(shape.in(), this.inHandler((Inlet<String>)shape.in(), (Outlet<String>)shape.out()));
        this.setHandler(shape.out(), this.outHandler((Inlet<String>)shape.in()));
        Statics.releaseFence();
    }
}

