/*
 * Decompiled with CFR 0.152.
 */
package pl.jozwik.smtp.server;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.time.format.DateTimeFormatter;
import org.apache.pekko.Done;
import org.apache.pekko.NotUsed;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Materializer$;
import org.apache.pekko.stream.UniformFanInShape;
import org.apache.pekko.stream.scaladsl.Concat$;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.Framing$;
import org.apache.pekko.stream.scaladsl.GraphDSL;
import org.apache.pekko.stream.scaladsl.GraphDSL$;
import org.apache.pekko.stream.scaladsl.Sink;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.stream.scaladsl.Tcp;
import org.apache.pekko.stream.scaladsl.Tcp$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import pl.jozwik.smtp.server.AddressHandler;
import pl.jozwik.smtp.server.Configuration;
import pl.jozwik.smtp.server.SmtpGraphStage;
import pl.jozwik.smtp.server.StreamServer$;
import pl.jozwik.smtp.util.Constants$;
import pl.jozwik.smtp.util.ConsumedResult;
import pl.jozwik.smtp.util.IOUtils$;
import pl.jozwik.smtp.util.Mail;
import pl.jozwik.smtp.util.SizeParameterHandler;
import pl.jozwik.smtp.util.Utils$;
import scala.Function1;
import scala.MatchError;
import scala.collection.immutable.Iterable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005Ew!\u0002\u000e\u001c\u0011\u0003!c!\u0002\u0014\u001c\u0011\u00039\u0003\"\u0002\u001d\u0002\t\u0003I\u0004\"\u0002\u001e\u0002\t\u0003Y\u0004\"CAW\u0003E\u0005I\u0011AAX\u0011%\t)-\u0001b\u0001\n\u0013\t9\r\u0003\u0005\u0002P\u0006\u0001\u000b\u0011BAe\r\u001113\u0004\u0001 \t\u0011);!\u0011!Q\u0001\n-C\u0001\"X\u0004\u0003\u0002\u0003\u0006IA\u0018\u0005\tC\u001e\u0011\t\u0011)A\u0005E\"AQm\u0002B\u0001B\u0003-a\rC\u00039\u000f\u0011%!\u000fC\u0004y\u000f\t\u0007I\u0011B=\t\ru<\u0001\u0015!\u0003{\u0011\u001dqxA1A\u0005\n}D\u0001\"a\u0002\bA\u0003%\u0011\u0011\u0001\u0005\b\u0003\u00139A\u0011BA\u0006\u0011\u001d\t\u0019d\u0002C\u0005\u0003kA\u0011\"!\u0018\b\u0005\u0004%I!a\u0018\t\u0011\u0005ut\u0001)A\u0005\u0003CB\u0011\"a \b\u0005\u0004%I!!!\t\u0011\u0005Eu\u0001)A\u0005\u0003\u0007C\u0011\"a%\b\u0005\u0004%I!!&\t\u0011\u0005]u\u0001)A\u0005\u0003\u0013Cq!!'\b\t\u0003\tY*\u0001\u0007TiJ,\u0017-\\*feZ,'O\u0003\u0002\u001d;\u000511/\u001a:wKJT!AH\u0010\u0002\tMlG\u000f\u001d\u0006\u0003A\u0005\naA[8{o&\\'\"\u0001\u0012\u0002\u0005Ad7\u0001\u0001\t\u0003K\u0005i\u0011a\u0007\u0002\r'R\u0014X-Y7TKJ4XM]\n\u0004\u0003!r\u0003CA\u0015-\u001b\u0005Q#\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R#AB!osJ+g\r\u0005\u00020m5\t\u0001G\u0003\u00022e\u0005a1oY1mC2|wmZ5oO*\u00111\u0007N\u0001\tif\u0004Xm]1gK*\tQ'A\u0002d_6L!a\u000e\u0019\u0003\u001bM#(/[2u\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\tA%A\u0003baBd\u0017\u0010F\u0004=\u0003O\u000bI+a+\u0015\u0007u\n\u0019\u000b\u0005\u0002&\u000fM!qaP$/!\t\u0001U)D\u0001B\u0015\t\u00115)\u0001\u0003mC:<'\"\u0001#\u0002\t)\fg/Y\u0005\u0003\r\u0006\u0013aa\u00142kK\u000e$\bC\u0001!I\u0013\tI\u0015IA\u0007BkR|7\t\\8tK\u0006\u0014G.Z\u0001\tG>t7/^7feB!\u0011\u0006\u0014(U\u0013\ti%FA\u0005Gk:\u001cG/[8ocA\u0011qJU\u0007\u0002!*\u0011\u0011+H\u0001\u0005kRLG.\u0003\u0002T!\n!Q*Y5m!\r)\u0006LW\u0007\u0002-*\u0011qKK\u0001\u000bG>t7-\u001e:sK:$\u0018BA-W\u0005\u00191U\u000f^;sKB\u0011qjW\u0005\u00039B\u0013abQ8ogVlW\r\u001a*fgVdG/A\u0007d_:4\u0017nZ;sCRLwN\u001c\t\u0003K}K!\u0001Y\u000e\u0003\u001b\r{gNZ5hkJ\fG/[8o\u00039\tG\r\u001a:fgND\u0015M\u001c3mKJ\u0004\"!J2\n\u0005\u0011\\\"AD!eIJ,7o\u001d%b]\u0012dWM]\u0001\u0007gf\u001cH/Z7\u0011\u0005\u001d\u0004X\"\u00015\u000b\u0005%T\u0017!B1di>\u0014(BA6m\u0003\u0015\u0001Xm[6p\u0015\tig.\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002_\u0006\u0019qN]4\n\u0005ED'aC!di>\u00148+_:uK6$Ba];woR\u0011Q\b\u001e\u0005\u0006K2\u0001\u001dA\u001a\u0005\u0006\u00152\u0001\ra\u0013\u0005\u0006;2\u0001\rA\u0018\u0005\u0006C2\u0001\rAY\u0001\fg&TX\rS1oI2,'/F\u0001{!\ty50\u0003\u0002}!\n!2+\u001b>f!\u0006\u0014\u0018-\\3uKJD\u0015M\u001c3mKJ\fAb]5{K\"\u000bg\u000e\u001a7fe\u0002\nA\u0001]8siV\u0011\u0011\u0011\u0001\t\u0004S\u0005\r\u0011bAA\u0003U\t\u0019\u0011J\u001c;\u0002\u000bA|'\u000f\u001e\u0011\u0002\u000f!\fg\u000e\u001a7feR1\u0011QBA\n\u0003G\u00012!JA\b\u0013\r\t\tb\u0007\u0002\u000f'6$\bo\u0012:ba\"\u001cF/Y4f\u0011\u001d\t)\"\u0005a\u0001\u0003/\taA]3n_R,\u0007\u0003BA\r\u0003?i!!a\u0007\u000b\u0007\u0005u1)A\u0002oKRLA!!\t\u0002\u001c\t\t\u0012J\\3u'>\u001c7.\u001a;BI\u0012\u0014Xm]:\t\u000f\u0005\u0015\u0012\u00031\u0001\u0002(\u0005Y!/Z1e)&lWm\\;u!\u0011\tI#a\f\u000e\u0005\u0005-\"bAA\u0017-\u0006AA-\u001e:bi&|g.\u0003\u0003\u00022\u0005-\"A\u0004$j]&$X\rR;sCRLwN\\\u0001\fg\u0016\u0014h/\u001a:M_\u001eL7\r\u0006\u0003\u00028\u0005e\u0003CCA\u001d\u0003\u0007\n9%a\u0012\u0002R5\u0011\u00111\b\u0006\u0005\u0003{\ty$\u0001\u0005tG\u0006d\u0017\rZ:m\u0015\r\t\tE[\u0001\u0007gR\u0014X-Y7\n\t\u0005\u0015\u00131\b\u0002\u0005\r2|w\u000f\u0005\u0003\u0002J\u00055SBAA&\u0015\t\t&.\u0003\u0003\u0002P\u0005-#A\u0003\"zi\u0016\u001cFO]5oOB!\u00111KA+\u001b\u0005Q\u0017bAA,U\n9aj\u001c;Vg\u0016$\u0007bBA.%\u0001\u0007\u0011qC\u0001\u000ee\u0016lw\u000e^3BI\u0012\u0014Xm]:\u0002#\r|gN\\3di&|g\u000eS1oI2,'/\u0006\u0002\u0002bAA\u0011\u0011HA2\u0003O\n)(\u0003\u0003\u0002f\u0005m\"\u0001B*j].\u0004B!!\u001b\u0002p9!\u0011\u0011HA6\u0013\u0011\ti'a\u000f\u0002\u0007Q\u001b\u0007/\u0003\u0003\u0002r\u0005M$AE%oG>l\u0017N\\4D_:tWm\u0019;j_:TA!!\u001c\u0002<A!Q\u000bWA<!\u0011\t\u0019&!\u001f\n\u0007\u0005m$N\u0001\u0003E_:,\u0017AE2p]:,7\r^5p]\"\u000bg\u000e\u001a7fe\u0002\n1#\u001b8d_6LgnZ\"p]:,7\r^5p]N,\"!a!\u0011\u0011\u0005e\u0012QQA4\u0003\u0013KA!a\"\u0002<\t11k\\;sG\u0016\u0004B!\u0016-\u0002\fB!\u0011\u0011NAG\u0013\u0011\ty)a\u001d\u0003\u001bM+'O^3s\u0005&tG-\u001b8h\u0003QIgnY8nS:<7i\u001c8oK\u000e$\u0018n\u001c8tA\u00059!-\u001b8eS:<WCAAE\u0003!\u0011\u0017N\u001c3j]\u001e\u0004\u0013!B2m_N,GCAAO!\rI\u0013qT\u0005\u0004\u0003CS#\u0001B+oSRDa!!*\u0004\u0001\b1\u0017aC1di>\u00148+_:uK6DQAS\u0002A\u0002-CQ!X\u0002A\u0002yCq!Y\u0002\u0011\u0002\u0003\u0007!-A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\t\tLK\u0002c\u0003g[#!!.\u0011\t\u0005]\u0016\u0011Y\u0007\u0003\u0003sSA!a/\u0002>\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u007fS\u0013AC1o]>$\u0018\r^5p]&!\u00111YA]\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\bC\u0012$'/Z:t+\t\tI\rE\u0002A\u0003\u0017L1!!4B\u0005\u0019\u0019FO]5oO\u0006A\u0011\r\u001a3sKN\u001c\b\u0005")
public class StreamServer
implements AutoCloseable,
StrictLogging {
    private final Function1<Mail, Future<ConsumedResult>> consumer;
    private final Configuration configuration;
    private final AddressHandler addressHandler;
    private final ActorSystem system;
    private final SizeParameterHandler sizeHandler;
    private final int port;
    private final Sink<Tcp.IncomingConnection, Future<Done>> connectionHandler;
    private final Source<Tcp.IncomingConnection, Future<Tcp.ServerBinding>> incomingConnections;
    private final Future<Tcp.ServerBinding> binding;
    private Logger logger;

    public static AddressHandler apply$default$3() {
        return StreamServer$.MODULE$.apply$default$3();
    }

    public static StreamServer apply(Function1<Mail, Future<ConsumedResult>> consumer, Configuration configuration, AddressHandler addressHandler, ActorSystem actorSystem) {
        return StreamServer$.MODULE$.apply(consumer, configuration, addressHandler, actorSystem);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private SizeParameterHandler sizeHandler() {
        return this.sizeHandler;
    }

    private int port() {
        return this.port;
    }

    private SmtpGraphStage handler(InetSocketAddress remote, FiniteDuration readTimeout) {
        return new SmtpGraphStage(this.addressHandler, this.sizeHandler(), IOUtils$.MODULE$.localHostName(), remote, this.consumer, readTimeout, this.system);
    }

    private Flow<ByteString, ByteString, NotUsed> serverLogic(InetSocketAddress remoteAddress) {
        return Flow$.MODULE$.fromGraph(GraphDSL$.MODULE$.create((Function1 & Serializable)b -> {
            String date = DateTimeFormatter.RFC_1123_DATE_TIME.format(Utils$.MODULE$.now());
            Source welcome = Source$.MODULE$.single((Object)ByteString$.MODULE$.apply(Utils$.MODULE$.withEndOfLine(new StringBuilder(14).append(Constants$.MODULE$.SERVICE_READY()).append(" ").append(IOUtils$.MODULE$.localHostName()).append(" SMTP SERVER ").append(date).toString())));
            FlowShape logic = (FlowShape)b.add((Graph)((Flow)Flow$.MODULE$.apply().via((Graph)Framing$.MODULE$.delimiter(ByteString$.MODULE$.apply(Constants$.MODULE$.delimiter()), Constants$.MODULE$.maximumFrameLength(), true)).map((Function1 & Serializable)x$1 -> x$1.utf8String()).map((Function1 & Serializable)msg -> {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Server received: {}", msg);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return new StringBuilder(0).append((String)msg).append(Constants$.MODULE$.delimiter()).toString();
            })).via((Graph)this.handler(remoteAddress, $this.configuration.readTimeout())).map((Function1 & Serializable)string -> ByteString$.MODULE$.apply(string)));
            UniformFanInShape concat = (UniformFanInShape)b.add(Concat$.MODULE$.apply(Concat$.MODULE$.apply$default$1()));
            new GraphDSL.Implicits$.SourceArrow(GraphDSL.Implicits$.MODULE$.SourceArrow((Graph)welcome)).$tilde$greater(concat.in(0), b);
            GraphDSL.Implicits$.MODULE$.port2flow(GraphDSL.Implicits$.MODULE$.flow2flow(logic, b).outlet(), b).$tilde$greater(concat.in(1), b);
            return new FlowShape(logic.in(), concat.out());
        }));
    }

    private Sink<Tcp.IncomingConnection, Future<Done>> connectionHandler() {
        return this.connectionHandler;
    }

    private Source<Tcp.IncomingConnection, Future<Tcp.ServerBinding>> incomingConnections() {
        return this.incomingConnections;
    }

    private Future<Tcp.ServerBinding> binding() {
        return this.binding;
    }

    @Override
    public void close() {
        this.binding().foreach((Function1 & Serializable)x$2 -> x$2.unbind(), (ExecutionContext)this.system.dispatcher());
    }

    public static final /* synthetic */ void $anonfun$connectionHandler$1(StreamServer $this, Tcp.IncomingConnection conn) {
        BoxedUnit boxedUnit;
        InetSocketAddress remoteAddress = conn.remoteAddress();
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug("Incoming connection from: {}", (Object)remoteAddress);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        conn.handleWith($this.serverLogic(remoteAddress), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)$this.system));
    }

    public static final /* synthetic */ void $anonfun$new$1(StreamServer $this, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Tcp.ServerBinding b = (Tcp.ServerBinding)success.value();
            if ($this.logger().underlying().isDebugEnabled()) {
                $this.logger().underlying().debug("Server started, listening on: {}", (Object)b.localAddress());
                return;
            }
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if ($this.logger().underlying().isErrorEnabled()) {
                $this.logger().underlying().error("Server could not be bound to {}:{}: {}", new Object[]{StreamServer$.MODULE$.pl$jozwik$smtp$server$StreamServer$$address(), BoxesRunTime.boxToInteger((int)$this.port()), e.getMessage()});
                return;
            }
            return;
        }
        throw new MatchError((Object)try_);
    }

    public StreamServer(Function1<Mail, Future<ConsumedResult>> consumer, Configuration configuration, AddressHandler addressHandler, ActorSystem system) {
        this.consumer = consumer;
        this.configuration = configuration;
        this.addressHandler = addressHandler;
        this.system = system;
        StrictLogging.$init$((StrictLogging)this);
        this.sizeHandler = new SizeParameterHandler(configuration.size());
        this.port = configuration.port();
        this.connectionHandler = Sink$.MODULE$.foreach((Function1 & Serializable)conn -> {
            StreamServer.$anonfun$connectionHandler$1(this, conn);
            return BoxedUnit.UNIT;
        });
        Tcp qual$1 = Tcp$.MODULE$.apply(system);
        String x$1 = StreamServer$.MODULE$.pl$jozwik$smtp$server$StreamServer$$address();
        int x$2 = this.port();
        int x$3 = qual$1.bind$default$3();
        Iterable x$4 = qual$1.bind$default$4();
        boolean x$5 = qual$1.bind$default$5();
        Duration x$6 = qual$1.bind$default$6();
        this.incomingConnections = qual$1.bind(x$1, x$2, x$3, x$4, x$5, x$6);
        this.binding = (Future)this.incomingConnections().to(this.connectionHandler()).run(Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)system));
        this.binding().onComplete((Function1 & Serializable)x0$1 -> {
            StreamServer.$anonfun$new$1(this, x0$1);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)system.dispatcher());
        Statics.releaseFence();
    }
}

