/*
 * Decompiled with CFR 0.152.
 */
package pl.jozwik.smtp.server.command;

import java.time.ZonedDateTime;
import pl.jozwik.smtp.server.AddressHandler;
import pl.jozwik.smtp.server.Content;
import pl.jozwik.smtp.server.Errors$;
import pl.jozwik.smtp.server.MailAccumulator;
import pl.jozwik.smtp.server.ResponseMessage;
import pl.jozwik.smtp.server.command.package$;
import pl.jozwik.smtp.util.Constants$;
import pl.jozwik.smtp.util.MailAddress;
import pl.jozwik.smtp.util.MailAddress$;
import pl.jozwik.smtp.util.ParameterHandler;
import pl.jozwik.smtp.util.Parameters$;
import pl.jozwik.smtp.util.Response$;
import pl.jozwik.smtp.util.SizeParameterHandler;
import pl.jozwik.smtp.util.Utils$;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class MailCommand$ {
    public static final MailCommand$ MODULE$ = new MailCommand$();

    public Tuple2<MailAccumulator, ResponseMessage> handleMail(String command, Iterator<String> commandIterator, String argument, MailAccumulator accumulator, SizeParameterHandler sizeHandler, AddressHandler addressHandler) {
        boolean bl = accumulator.needHello();
        if (bl) {
            return package$.MODULE$.response(accumulator, Errors$.MODULE$.HELLO_FIRST());
        }
        if (commandIterator.hasNext()) {
            Object object = commandIterator.next();
            String string = Constants$.MODULE$.FROM();
            if (!(object != null ? !object.equals(string) : string != null) && !commandIterator.hasNext()) {
                return this.addMail(argument, accumulator, sizeHandler, addressHandler);
            }
        }
        return package$.MODULE$.response(accumulator, Errors$.MODULE$.syntaxError(command));
    }

    private Tuple2<MailAccumulator, ResponseMessage> addMail(String argument, MailAccumulator accumulator, SizeParameterHandler sizeHandler, AddressHandler addressHandler) {
        if (accumulator.from().isEmpty()) {
            Map parameterHandlerMap = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)sizeHandler.key()), (Object)sizeHandler)}));
            return this.addMailFrom(argument, accumulator, (Map<String, ParameterHandler>)parameterHandlerMap, addressHandler);
        }
        return package$.MODULE$.response(accumulator, Errors$.MODULE$.SENDER_ALREADY_SPECIFIED());
    }

    private Tuple2<MailAccumulator, ResponseMessage> addMailFrom(String argument, MailAccumulator accumulator, Map<String, ParameterHandler> parameterHandlerMap, AddressHandler addressHandler) {
        Tuple3<String, MailAddress, Seq<Tuple2<String, String>>> tuple3 = this.responseForMail(argument, addressHandler);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String message = (String)tuple3._1();
        MailAddress from = (MailAddress)tuple3._2();
        Seq parameters = (Seq)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)message, (Object)from, (Object)parameters);
        String message2 = (String)tuple32._1();
        MailAddress from2 = (MailAddress)tuple32._2();
        Seq parameters2 = (Seq)tuple32._3();
        Either either = Parameters$.MODULE$.validate(parameters2, parameterHandlerMap);
        if (either instanceof Left) {
            Left left = (Left)either;
            String error = (String)left.value();
            return package$.MODULE$.response(accumulator, error);
        }
        MailAddress x$1 = from2;
        boolean x$2 = accumulator.copy$default$1();
        Seq<MailAddress> x$3 = accumulator.copy$default$3();
        Content x$4 = accumulator.copy$default$4();
        boolean x$5 = accumulator.copy$default$5();
        Option<String> x$6 = accumulator.copy$default$6();
        ZonedDateTime x$7 = accumulator.copy$default$7();
        return package$.MODULE$.response(accumulator.copy(x$2, x$1, x$3, x$4, x$5, x$6, x$7), message2);
    }

    private Tuple3<String, MailAddress, Seq<Tuple2<String, String>>> responseForMail(String argument, AddressHandler addressHandler) {
        Right right;
        Tuple2 tuple2;
        Either either = Utils$.MODULE$.extractAddressAndParameters(argument);
        if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
            String address = (String)tuple2._1();
            Map map = (Map)tuple2._2();
            Tuple2<String, MailAddress> tuple22 = this.extractSender(argument, addressHandler, address);
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            String response = (String)tuple22._1();
            MailAddress mailAddress = (MailAddress)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)response, (Object)mailAddress);
            String response2 = (String)tuple23._1();
            MailAddress mailAddress2 = (MailAddress)tuple23._2();
            return new Tuple3((Object)response2, (Object)mailAddress2, (Object)map.toSeq());
        }
        if (either instanceof Left) {
            Left left = (Left)either;
            String response = (String)left.value();
            return new Tuple3((Object)response, (Object)MailAddress$.MODULE$.empty(), (Object)scala.package$.MODULE$.Seq().empty());
        }
        throw new MatchError((Object)either);
    }

    private Tuple2<String, MailAddress> extractSender(String argument, AddressHandler addressHandler, String address) {
        Either either = Utils$.MODULE$.toMailAddress(address);
        if (either instanceof Right) {
            Right right = (Right)either;
            MailAddress from = (MailAddress)right.value();
            String response = addressHandler.acceptFrom(from) ? Response$.MODULE$.senderOk(from) : Errors$.MODULE$.domainNotResolved(from);
            return new Tuple2((Object)response, (Object)from);
        }
        if (either instanceof Left) {
            String response = argument.isEmpty() ? Errors$.MODULE$.syntaxError(Constants$.MODULE$.FROM()) : Response$.MODULE$.domainNameRequired(argument);
            return new Tuple2((Object)response, (Object)MailAddress$.MODULE$.empty());
        }
        throw new MatchError((Object)either);
    }

    private MailCommand$() {
    }
}

