/*
 * Decompiled with CFR 0.152.
 */
package pl.jozwik.smtp.util;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.james.mime4j.dom.Body;
import org.apache.james.mime4j.dom.Entity;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.Multipart;
import org.apache.james.mime4j.dom.SingleBody;
import org.apache.james.mime4j.dom.TextBody;
import org.apache.james.mime4j.dom.address.Mailbox;
import org.apache.james.mime4j.dom.address.MailboxList;
import org.apache.james.mime4j.message.BasicBodyFactory;
import org.apache.james.mime4j.message.DefaultMessageBuilder;
import org.apache.james.mime4j.message.DefaultMessageWriter;
import pl.jozwik.smtp.util.Attachment;
import pl.jozwik.smtp.util.EmailWithContent;
import pl.jozwik.smtp.util.Mail;
import pl.jozwik.smtp.util.MailAddress;
import pl.jozwik.smtp.util.TmpEmailContent;
import pl.jozwik.smtp.util.TmpEmailContent$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class MailParser$
implements StrictLogging {
    public static final MailParser$ MODULE$ = new MailParser$();
    private static final DefaultMessageBuilder messageBuilder;
    private static final DefaultMessageWriter writer;
    private static Logger logger;

    static {
        StrictLogging.$init$((StrictLogging)MODULE$);
        messageBuilder = new DefaultMessageBuilder();
        writer = new DefaultMessageWriter();
    }

    public Logger logger() {
        return logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    public DefaultMessageBuilder messageBuilder() {
        return messageBuilder;
    }

    private DefaultMessageWriter writer() {
        return writer;
    }

    public EmailWithContent parse(String mailAsTxt) {
        Message mimeMsg = this.toMessage(mailAsTxt);
        return this.parseMessage(mimeMsg);
    }

    public Message toMessage(String mailAsTxt) {
        return this.messageBuilder().parseMessage((InputStream)new ByteArrayInputStream(mailAsTxt.getBytes()));
    }

    public EmailWithContent parseMessage(Message mimeMsg) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        Option subject = Option$.MODULE$.apply((Object)mimeMsg.getSubject());
        Seq<MailAddress> from = this.toList((Option<MailboxList>)Option$.MODULE$.apply((Object)mimeMsg.getFrom()));
        Seq<MailAddress> to = this.toList((Option<MailboxList>)Option$.MODULE$.apply((Object)mimeMsg.getTo()).map((Function1 & Serializable)x$1 -> x$1.flatten()));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("To: {}", (Object)mimeMsg.getTo());
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("From: {}", (Object)mimeMsg.getFrom());
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Subject: {}", (Object)subject);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Body body = mimeMsg.getBody();
        if (body instanceof Multipart) {
            Multipart multipart = (Multipart)body;
            TmpEmailContent acc = this.parseBodyParts((Seq<Entity>)CollectionConverters$.MODULE$.ListHasAsScala(multipart.getBodyParts()).asScala().toSeq(), TmpEmailContent$.MODULE$.empty());
            Option<String> htmlBody = this.toOption(acc.htmlBody());
            Option<String> txtBody = this.toOption(acc.txtBody());
            return new EmailWithContent(from, to, (Option<String>)subject, txtBody, htmlBody, acc.attachments());
        }
        if (body instanceof SingleBody) {
            SingleBody singleBody = (SingleBody)body;
            String text = this.getTxtPart(singleBody);
            return new EmailWithContent(from, to, (Option<String>)subject, (Option<String>)Option$.MODULE$.apply((Object)text), (Option<String>)None$.MODULE$, (Seq<Attachment>)((Seq)package$.MODULE$.Seq().empty()));
        }
        throw new UnsupportedOperationException(String.valueOf(body));
    }

    private Seq<MailAddress> toList(Option<MailboxList> mailboxList) {
        return (Seq)mailboxList.map((Function1 & Serializable)list -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), list.size()).map((Function1 & Serializable)i -> MailParser$.$anonfun$toList$2(list, BoxesRunTime.unboxToInt((Object)i)))).getOrElse((Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty());
    }

    public String createTextMessage(Mail mail) {
        EmailWithContent emailContent = mail.emailContent();
        TextBody body = new BasicBodyFactory().textBody(emailContent.bodyAsString(), StandardCharsets.UTF_8);
        Message.Builder builder = Message.Builder.of().setSubject((String)emailContent.subject().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).setBody(body);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writer().writeMessage(builder.build(), (OutputStream)out);
        return out.toString();
    }

    private String getTxtPart(SingleBody singleBody) {
        byte[] bytes = this.toByteArray(singleBody);
        return new String(bytes);
    }

    private Option<String> toOption(IndexedSeq<String> seq) {
        if (seq.isEmpty()) {
            return None$.MODULE$;
        }
        return Option$.MODULE$.apply((Object)seq.mkString());
    }

    private TmpEmailContent addMultipart(Multipart m, TmpEmailContent accWithPart) {
        return this.parseBodyParts((Seq<Entity>)CollectionConverters$.MODULE$.ListHasAsScala(m.getBodyParts()).asScala().toSeq(), accWithPart);
    }

    private TmpEmailContent addSingleBody(TmpEmailContent acc, String mime, SingleBody b, Entity part) {
        String string = mime;
        switch (string == null ? 0 : string.hashCode()) {
            case -1082243251: {
                if (!"text/html".equals(string)) break;
                String html = this.getTxtPart(b);
                IndexedSeq x$1 = (IndexedSeq)acc.htmlBody().$colon$plus((Object)html);
                IndexedSeq<String> x$22 = acc.copy$default$1();
                Seq<Attachment> x$3 = acc.copy$default$3();
                return acc.copy(x$22, (IndexedSeq<String>)x$1, x$3);
            }
            case 817335912: {
                if (!"text/plain".equals(string)) break;
                String txt = this.getTxtPart(b);
                return acc.copy((IndexedSeq<String>)((IndexedSeq)acc.txtBody().$colon$plus((Object)txt)), acc.copy$default$2(), acc.copy$default$3());
            }
        }
        if (Option$.MODULE$.apply((Object)part.getDispositionType()).exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MailParser$.$anonfun$addSingleBody$1(x$2)))) {
            byte[] bytes = this.toByteArray(b);
            Attachment attachment = new Attachment(part.getFilename(), bytes);
            Seq x$4 = (Seq)acc.attachments().$plus$colon((Object)attachment);
            IndexedSeq<String> x$5 = acc.copy$default$1();
            IndexedSeq<String> x$6 = acc.copy$default$2();
            return acc.copy(x$5, x$6, (Seq<Attachment>)x$4);
        }
        return acc;
    }

    private TmpEmailContent parseBodyParts(Seq<Entity> entities, TmpEmailContent acc) {
        Option option;
        Seq seq;
        while ((seq = entities) != null && !(option = package$.MODULE$.$plus$colon().unapply(seq)).isEmpty()) {
            TmpEmailContent accWithPart;
            TmpEmailContent tmpEmailContent;
            Entity part = (Entity)((Tuple2)option.get())._1();
            Seq tail = (Seq)((Tuple2)option.get())._2();
            Body body = part.getBody();
            if (body instanceof SingleBody) {
                SingleBody singleBody = (SingleBody)body;
                tmpEmailContent = this.addSingleBody(acc, part.getMimeType().toLowerCase(), singleBody, part);
            } else if (body instanceof Multipart) {
                Multipart multipart = (Multipart)body;
                tmpEmailContent = this.addMultipart(multipart, acc);
            } else {
                throw new UnsupportedOperationException(String.valueOf(body.getClass()));
            }
            acc = accWithPart = tmpEmailContent;
            entities = tail;
        }
        return acc;
    }

    private byte[] toByteArray(SingleBody singleBody) {
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        singleBody.writeTo((OutputStream)fos);
        return fos.toByteArray();
    }

    public static final /* synthetic */ MailAddress $anonfun$toList$2(MailboxList list$1, int i) {
        BoxedUnit boxedUnit;
        Mailbox el = list$1.get(i);
        String name = el.getLocalPart();
        String domain = el.getDomain();
        if (MODULE$.logger().underlying().isDebugEnabled()) {
            MODULE$.logger().underlying().debug("{} {}", new Object[]{el.getAddress(), el.getName()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new MailAddress(name, domain);
    }

    public static final /* synthetic */ boolean $anonfun$addSingleBody$1(String x$2) {
        String string = x$2;
        String string2 = "";
        return string == null ? string2 != null : !string.equals(string2);
    }

    private MailParser$() {
    }
}

