/*
 * Decompiled with CFR 0.152.
 */
package pl.jozwik.smtp.util;

import java.io.Serializable;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import pl.jozwik.smtp.util.Constants$;
import pl.jozwik.smtp.util.EmailWithContent;
import pl.jozwik.smtp.util.MailAddress;
import pl.jozwik.smtp.util.MailParser$;
import pl.jozwik.smtp.util.Response$;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.ArraySeq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Utils$ {
    public static final Utils$ MODULE$ = new Utils$();
    private static final Pattern WHITE_SPACES_PATTERN = Pattern.compile("\\s+");

    private Pattern WHITE_SPACES_PATTERN() {
        return WHITE_SPACES_PATTERN;
    }

    public ZonedDateTime now() {
        return ZonedDateTime.now(ZoneOffset.UTC);
    }

    public String withEndOfLine(String line) {
        return new StringBuilder(0).append(line).append(Constants$.MODULE$.crLf()).toString();
    }

    public Tuple2<String, String> splitLineByColon(String message) {
        Tuple2 tuple2;
        int n = message.indexOf(":");
        if (-1 == n) {
            tuple2 = new Tuple2((Object)message, (Object)"");
        } else if (true) {
            int n2 = n;
            tuple2 = new Tuple2((Object)message.substring(0, n2), (Object)message.substring(n2 + 1));
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        String head = (String)tuple22._1();
        String argument = (String)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)head, (Object)argument);
        String head2 = (String)tuple23._1();
        String argument2 = (String)tuple23._2();
        return new Tuple2((Object)head2.trim(), (Object)argument2.trim());
    }

    public IndexedSeq<String> splitOnWhiteSpaces(String txt, int limit) {
        return ArraySeq$.MODULE$.unsafeWrapArray((Object)this.WHITE_SPACES_PATTERN().split(txt, limit));
    }

    public int splitOnWhiteSpaces$default$2() {
        return 0;
    }

    public Either<String, Tuple2<String, Map<String, String>>> extractAddressAndParameters(String txt) {
        Right right;
        Tuple2 tuple2;
        Either<String, Tuple2<String, Seq<String>>> either = this.extractMailAddress(txt.trim());
        if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
            String addressWithoutBrackets = (String)tuple2._1();
            Seq parameters = (Seq)tuple2._2();
            return this.validateBrackets(addressWithoutBrackets, (Function1 & Serializable)address -> {
                Either<String, Map<String, String>> either = MODULE$.parametersToMap((Seq<String>)parameters);
                if (either instanceof Right) {
                    Right right = (Right)either;
                    Map map = (Map)right.value();
                    return package$.MODULE$.Right().apply((Object)new Tuple2(address, (Object)map));
                }
                if (either instanceof Left) {
                    Left left = (Left)either;
                    String error = (String)left.value();
                    return package$.MODULE$.Left().apply((Object)error);
                }
                throw new MatchError(either);
            });
        }
        if (either instanceof Left) {
            Left left = (Left)either;
            String error = (String)left.value();
            return package$.MODULE$.Left().apply((Object)error);
        }
        throw new MatchError(either);
    }

    public Either<String, Map<String, String>> parametersToMap(Seq<String> seq) {
        return this.parametersToMap$1(seq, Predef$.MODULE$.Map().empty());
    }

    private Either<String, Tuple2<String, Seq<String>>> extractMailAddress(String maybeInBrackets) {
        Tuple2.mcZI.sp sp2 = new Tuple2.mcZI.sp(maybeInBrackets.startsWith(Constants$.MODULE$.OPEN_BRACKET_STRING()), maybeInBrackets.lastIndexOf(Constants$.MODULE$.CLOSE_BRACKET()));
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            int end = sp2._2$mcI$sp();
            if (bl) {
                return this.extractMailAddressCloseBracket(maybeInBrackets, end);
            }
        }
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            int end = sp2._2$mcI$sp();
            if (!bl && end != -1) {
                return package$.MODULE$.Left().apply((Object)Response$.MODULE$.unbalanced(maybeInBrackets, Constants$.MODULE$.CLOSE_BRACKET()));
            }
        }
        return package$.MODULE$.Right().apply(this.extractMailAddressWithoutBrackets(maybeInBrackets));
    }

    private Tuple2<String, Seq<String>> extractMailAddressWithoutBrackets(String notInBrackets) {
        SeqOps seqOps;
        IndexedSeq<String> indexedSeq = this.splitOnWhiteSpaces(notInBrackets, 2);
        if (indexedSeq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq(indexedSeq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
            String address = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            String parameters = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
            return new Tuple2((Object)address, this.splitOrEmpty(parameters));
        }
        return new Tuple2((Object)this.unsafeHead((Iterable)indexedSeq), (Object)package$.MODULE$.Seq().empty());
    }

    private Either<String, Tuple2<String, Seq<String>>> extractMailAddressCloseBracket(String inBrackets, int end) {
        if (end == -1) {
            return package$.MODULE$.Left().apply((Object)Response$.MODULE$.unbalanced(inBrackets, Constants$.MODULE$.OPEN_BRACKET()));
        }
        String address = this.removeDoubleBrackets(inBrackets.substring(1, end));
        String parameters = inBrackets.substring(end + 1);
        if (BoxesRunTime.unboxToChar((Object)StringOps$.MODULE$.headOption$extension(Predef$.MODULE$.augmentString(parameters)).getOrElse((Function0)(JFunction0.mcC.sp & Serializable)() -> Constants$.MODULE$.SPACE())) == Constants$.MODULE$.SPACE()) {
            return package$.MODULE$.Right().apply((Object)new Tuple2((Object)address, this.splitOrEmpty(parameters.trim())));
        }
        return package$.MODULE$.Left().apply((Object)Response$.MODULE$.BAD_SENDER_ADDRESS_SYNTAX());
    }

    private String removeDoubleBrackets(String maybeInBrackets) {
        String trimmed = maybeInBrackets.trim();
        if (trimmed.startsWith(Constants$.MODULE$.OPEN_BRACKET_STRING()) && trimmed.endsWith(Constants$.MODULE$.CLOSE_BRACKET_STRING())) {
            return trimmed.substring(1, trimmed.length() - 1);
        }
        return trimmed;
    }

    private Seq<String> splitOrEmpty(String txt) {
        if (txt.isEmpty()) {
            return (Seq)package$.MODULE$.Seq().empty();
        }
        return this.splitOnWhiteSpaces(txt, this.splitOnWhiteSpaces$default$2());
    }

    public Either<String, MailAddress> toMailAddress(String txt) {
        Either<String, String> either = this.cutBrackets(txt.trim());
        if (either instanceof Left) {
            Left left = (Left)either;
            String error = (String)left.value();
            return package$.MODULE$.Left().apply((Object)error);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            String withoutBrackets = (String)right.value();
            return this.validateBrackets(withoutBrackets, (Function1 & Serializable)addressWithoutBrackets -> MODULE$.notEmptyStringToMailAddress((String)addressWithoutBrackets));
        }
        throw new MatchError(either);
    }

    private <T> Either<String, T> validateBrackets(String withoutBrackets, Function1<String, Either<String, T>> f) {
        boolean bl;
        boolean bl2;
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(withoutBrackets), Constants$.MODULE$.CLOSE_BRACKET()), StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(withoutBrackets), Constants$.MODULE$.OPEN_BRACKET()));
        if (sp2 != null && (bl2 = sp2._1$mcZ$sp())) {
            return package$.MODULE$.Left().apply((Object)Response$.MODULE$.unbalanced(withoutBrackets, Constants$.MODULE$.CLOSE_BRACKET()));
        }
        if (sp2 != null && (bl = sp2._2$mcZ$sp())) {
            return package$.MODULE$.Left().apply((Object)Response$.MODULE$.unbalanced(withoutBrackets, Constants$.MODULE$.OPEN_BRACKET()));
        }
        return (Either)f.apply((Object)withoutBrackets);
    }

    private Either<String, MailAddress> notEmptyStringToMailAddress(String addressWithoutBrackets) {
        int n;
        int n2 = addressWithoutBrackets.indexOf(64);
        if (-1 == n2) {
            return package$.MODULE$.Left().apply((Object)Response$.MODULE$.domainNameRequired(addressWithoutBrackets));
        }
        if (true && (n = n2) != 0 && n != addressWithoutBrackets.length() - 1) {
            String user = addressWithoutBrackets.substring(0, n);
            String domain = addressWithoutBrackets.substring(n + 1, addressWithoutBrackets.length());
            return package$.MODULE$.Right().apply((Object)new MailAddress(user, domain.toLowerCase()));
        }
        return package$.MODULE$.Left().apply((Object)Response$.MODULE$.hostNameRequired(addressWithoutBrackets));
    }

    private Either<String, String> cutBrackets(String addressWithBrackets) {
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(addressWithBrackets.startsWith(Constants$.MODULE$.OPEN_BRACKET_STRING()), addressWithBrackets.endsWith(Constants$.MODULE$.CLOSE_BRACKET_STRING()));
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl2 = sp2._2$mcZ$sp();
            if (bl && bl2) {
                return package$.MODULE$.Right().apply((Object)addressWithBrackets.substring(1, addressWithBrackets.length() - 1).trim());
            }
        }
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl3 = sp2._2$mcZ$sp();
            if (bl && !bl3) {
                return package$.MODULE$.Left().apply((Object)Response$.MODULE$.unbalanced(addressWithBrackets, Constants$.MODULE$.CLOSE_BRACKET()));
            }
        }
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl4 = sp2._2$mcZ$sp();
            if (!bl && bl4) {
                return package$.MODULE$.Left().apply((Object)Response$.MODULE$.unbalanced(addressWithBrackets, Constants$.MODULE$.OPEN_BRACKET()));
            }
        }
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl5 = sp2._2$mcZ$sp();
            if (!bl && !bl5) {
                return package$.MODULE$.Right().apply((Object)addressWithBrackets);
            }
        }
        throw new MatchError((Object)sp2);
    }

    public EmailWithContent extractMessage(IndexedSeq<String> lines) {
        return MailParser$.MODULE$.parse(lines.mkString());
    }

    public <S> S unsafeHead(Iterable<S> seq) {
        return (S)seq.headOption().getOrElse((Function0 & Serializable)() -> {
            throw new NoSuchElementException();
        });
    }

    private final Either parametersToMap$1(Seq seq, Map map) {
        Option option;
        Seq seq2;
        while ((seq2 = seq) != null && !(option = package$.MODULE$.$plus$colon().unapply((SeqOps)seq2)).isEmpty()) {
            Object object;
            String h = (String)((Tuple2)option.get())._1();
            Seq t = (Seq)((Tuple2)option.get())._2();
            String[] stringArray = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(h), '=');
            if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) == 0) {
                String k = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                String v = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
                map = (Map)map.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k.trim().toUpperCase()), (Object)v.trim()));
                seq = t;
                continue;
            }
            return package$.MODULE$.Left().apply((Object)Response$.MODULE$.parameterUnrecognized(h));
        }
        return package$.MODULE$.Right().apply((Object)map);
    }

    private Utils$() {
    }
}

