/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerator;
import hu.akarnokd.asyncenum.ThrowableHelper;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.ExecutionException;

final class AsyncBlockingFirst {
    private AsyncBlockingFirst() {
        throw new IllegalStateException("No instances!");
    }

    public static <T> T blockingFirst(AsyncEnumerator<T> source) {
        try {
            Boolean result = source.moveNext().toCompletableFuture().get();
            if (result.booleanValue()) {
                T r = source.current();
                source.cancel();
                return r;
            }
            throw new NoSuchElementException();
        }
        catch (InterruptedException ex) {
            source.cancel();
            throw new RuntimeException(ex);
        }
        catch (ExecutionException ex) {
            throw ThrowableHelper.wrapOrThrow(ex.getCause());
        }
    }

    public static <T> Optional<T> blockingFirstOptional(AsyncEnumerator<T> source) {
        try {
            Boolean result = source.moveNext().toCompletableFuture().get();
            if (result.booleanValue()) {
                T r = source.current();
                source.cancel();
                return Optional.ofNullable(r);
            }
            return Optional.empty();
        }
        catch (InterruptedException ex) {
            source.cancel();
            throw new RuntimeException(ex);
        }
        catch (ExecutionException ex) {
            throw ThrowableHelper.wrapOrThrow(ex.getCause());
        }
    }
}

