/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import hu.akarnokd.asyncenum.ThrowableHelper;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutionException;

final class AsyncBlockingIterable<T>
implements Iterable<T> {
    final AsyncEnumerable<T> source;

    AsyncBlockingIterable(AsyncEnumerable<T> source) {
        this.source = source;
    }

    @Override
    public Iterator<T> iterator() {
        return new BlockingIterator<T>(this.source.enumerator());
    }

    static final class BlockingIterator<T>
    implements Iterator<T>,
    Runnable {
        final AsyncEnumerator<T> source;
        boolean hasValue;
        boolean done;
        T value;

        BlockingIterator(AsyncEnumerator<T> source) {
            this.source = source;
        }

        @Override
        public boolean hasNext() {
            if (!this.hasValue && !this.done) {
                try {
                    Boolean b = this.source.moveNext().toCompletableFuture().get();
                    if (b.booleanValue()) {
                        this.hasValue = true;
                        this.value = this.source.current();
                    } else {
                        this.done = true;
                    }
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
                catch (ExecutionException ex) {
                    throw ThrowableHelper.wrapOrThrow(ex.getCause());
                }
            }
            return this.hasValue;
        }

        @Override
        public T next() {
            if (this.hasValue || this.hasNext()) {
                T v = this.value;
                this.value = null;
                this.hasValue = false;
                return v;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void run() {
            this.source.cancel();
        }
    }
}

