/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerator;
import hu.akarnokd.asyncenum.ThrowableHelper;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;

final class AsyncBlockingLast<T>
extends CountDownLatch
implements BiConsumer<Boolean, Throwable> {
    final AsyncEnumerator<T> source;
    final AtomicInteger wip;
    boolean hasValue;
    T result;
    Throwable error;

    AsyncBlockingLast(AsyncEnumerator<T> source) {
        super(1);
        this.source = source;
        this.wip = new AtomicInteger();
    }

    void moveNext() {
        if (this.wip.getAndIncrement() == 0) {
            do {
                this.source.moveNext().whenComplete(this);
            } while (this.wip.decrementAndGet() != 0);
        }
    }

    @Override
    public void accept(Boolean aBoolean, Throwable throwable) {
        if (throwable != null) {
            this.result = null;
            this.error = throwable;
            this.countDown();
            return;
        }
        if (aBoolean.booleanValue()) {
            this.hasValue = true;
            this.result = this.source.current();
            this.moveNext();
        } else {
            this.countDown();
        }
    }

    T blockingGet() {
        Throwable ex;
        if (this.getCount() != 0L) {
            try {
                this.await();
            }
            catch (InterruptedException ex2) {
                this.source.cancel();
                throw new RuntimeException(ex2);
            }
        }
        if ((ex = this.error) != null) {
            throw ThrowableHelper.wrapOrThrow(ex);
        }
        if (this.hasValue) {
            return this.result;
        }
        throw new NoSuchElementException();
    }

    Optional<T> blockingGetOptional() {
        Throwable ex;
        if (this.getCount() != 0L) {
            try {
                this.await();
            }
            catch (InterruptedException ex2) {
                this.source.cancel();
                throw new RuntimeException(ex2);
            }
        }
        if ((ex = this.error) != null) {
            throw ThrowableHelper.wrapOrThrow(ex);
        }
        if (this.hasValue) {
            return Optional.ofNullable(this.result);
        }
        return Optional.empty();
    }
}

