/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;

final class AsyncCache<T>
extends AtomicInteger
implements AsyncEnumerable<T>,
BiConsumer<Boolean, Throwable> {
    final AsyncEnumerable<T> source;
    final AtomicBoolean once;
    final AtomicReference<CacheEnumerator<T>[]> enumerators;
    static final CacheEnumerator[] EMPTY = new CacheEnumerator[0];
    static final CacheEnumerator[] TERMINATED = new CacheEnumerator[0];
    final List<T> list;
    AsyncEnumerator<T> sourceEnumerator;
    volatile int size;
    volatile boolean done;
    Throwable error;

    AsyncCache(AsyncEnumerable<T> source) {
        this.source = source;
        this.once = new AtomicBoolean();
        this.enumerators = new AtomicReference<CacheEnumerator[]>(EMPTY);
        this.list = new ArrayList<T>();
    }

    @Override
    public void accept(Boolean aBoolean, Throwable throwable) {
        if (throwable != null) {
            this.error = throwable;
            this.done = true;
            for (CacheEnumerator en : this.enumerators.getAndSet(TERMINATED)) {
                this.signal(en);
            }
            return;
        }
        if (aBoolean.booleanValue()) {
            this.list.add(this.sourceEnumerator.current());
            ++this.size;
            for (CacheEnumerator<T> en : this.enumerators.getAcquire()) {
                this.signal(en);
            }
            this.nextSource();
        } else {
            this.done = true;
            for (CacheEnumerator en : this.enumerators.getAndSet(TERMINATED)) {
                this.signal(en);
            }
        }
    }

    @Override
    public AsyncEnumerator<T> enumerator() {
        CacheEnumerator en = new CacheEnumerator(this);
        if (this.add(en) && !this.once.get() && this.once.compareAndSet(false, true)) {
            this.sourceEnumerator = this.source.enumerator();
            this.nextSource();
        }
        this.signal(en);
        return en;
    }

    void nextSource() {
        if (this.getAndIncrement() == 0) {
            do {
                this.sourceEnumerator.moveNext().whenComplete(this);
            } while (this.decrementAndGet() != 0);
        }
    }

    boolean add(CacheEnumerator<T> inner) {
        CacheEnumerator[] b;
        CacheEnumerator<T>[] a;
        do {
            if ((a = this.enumerators.get()) == TERMINATED) {
                return false;
            }
            int n = a.length;
            b = new CacheEnumerator[n + 1];
            System.arraycopy(a, 0, b, 0, n);
            b[n] = inner;
        } while (!this.enumerators.compareAndSet(a, b));
        return true;
    }

    void remove(CacheEnumerator<T> inner) {
        CacheEnumerator<T>[] a;
        int n;
        while ((n = (a = this.enumerators.get()).length) != 0) {
            CacheEnumerator[] b;
            int j = -1;
            for (int i = 0; i < n; ++i) {
                if (a[i] != inner) continue;
                j = i;
                break;
            }
            if (j < 0) break;
            if (n == 1) {
                b = EMPTY;
            } else {
                b = new CacheEnumerator[n - 1];
                System.arraycopy(a, 0, b, 0, j);
                System.arraycopy(a, j + 1, b, j, n - j - 1);
            }
            if (!this.enumerators.compareAndSet(a, b)) continue;
            break;
        }
    }

    void signal(CacheEnumerator<T> target) {
        if (target.getAndIncrement() == 0) {
            do {
                boolean empty;
                CompletableFuture<Boolean> cf;
                if ((cf = target.completable) == null) continue;
                int index = target.index;
                boolean d = this.done;
                int s = this.size;
                boolean bl = empty = s == index;
                if (d && empty) {
                    target.completable = null;
                    Throwable ex = this.error;
                    if (ex != null) {
                        cf.completeExceptionally(ex);
                    } else {
                        cf.complete(false);
                    }
                }
                if (empty) continue;
                target.result = this.list.get(index);
                target.index = index + 1;
                target.completable = null;
                cf.complete(true);
            } while (target.decrementAndGet() != 0);
        }
    }

    static final class CacheEnumerator<T>
    extends AtomicInteger
    implements AsyncEnumerator<T> {
        final AsyncCache<T> parent;
        volatile CompletableFuture<Boolean> completable;
        int index;
        T result;

        CacheEnumerator(AsyncCache<T> parent) {
            this.parent = parent;
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            this.result = null;
            CompletableFuture<Boolean> cf = new CompletableFuture<Boolean>();
            this.completable = cf;
            this.parent.signal(this);
            return cf;
        }

        @Override
        public T current() {
            return this.result;
        }

        @Override
        public void cancel() {
            this.parent.remove(this);
        }
    }
}

