/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Supplier;

final class AsyncCollect<T, C>
implements AsyncEnumerable<C> {
    final AsyncEnumerable<T> source;
    final Supplier<C> supplier;
    final BiConsumer<C, T> collector;

    AsyncCollect(AsyncEnumerable<T> source, Supplier<C> supplier, BiConsumer<C, T> collector) {
        this.source = source;
        this.supplier = supplier;
        this.collector = collector;
    }

    @Override
    public AsyncEnumerator<C> enumerator() {
        return new CollectEnumerator<T, C>(this.source.enumerator(), this.collector, this.supplier.get());
    }

    static final class CollectEnumerator<T, C>
    extends AtomicInteger
    implements AsyncEnumerator<C>,
    BiConsumer<Boolean, Throwable> {
        final AsyncEnumerator<T> source;
        final BiConsumer<C, T> collector;
        C collection;
        C result;
        CompletableFuture<Boolean> cf;
        volatile boolean cancelled;

        CollectEnumerator(AsyncEnumerator<T> source, BiConsumer<C, T> collector, C collection) {
            this.source = source;
            this.collector = collector;
            this.collection = collection;
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            if (this.collection == null) {
                this.result = null;
                return AsyncEnumerable.FALSE;
            }
            this.cf = new CompletableFuture();
            this.collectSource();
            return this.cf;
        }

        @Override
        public C current() {
            return this.result;
        }

        void collectSource() {
            if (this.getAndIncrement() == 0) {
                do {
                    if (this.cancelled) {
                        return;
                    }
                    this.source.moveNext().whenComplete(this);
                } while (this.decrementAndGet() != 0);
            }
        }

        @Override
        public void accept(Boolean aBoolean, Throwable throwable) {
            if (throwable != null) {
                this.collection = null;
                this.cf.completeExceptionally(throwable);
                return;
            }
            if (aBoolean.booleanValue()) {
                this.collector.accept(this.collection, this.source.current());
                this.collectSource();
            } else {
                this.result = this.collection;
                this.collection = null;
                this.cf.complete(true);
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.source.cancel();
        }
    }
}

