/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collector;

final class AsyncCollectWith<T, A, R>
implements AsyncEnumerable<R> {
    final AsyncEnumerable<T> source;
    final Collector<T, A, R> collector;

    AsyncCollectWith(AsyncEnumerable<T> source, Collector<T, A, R> collector) {
        this.source = source;
        this.collector = collector;
    }

    @Override
    public AsyncEnumerator<R> enumerator() {
        return new CollectWithEnumerator<T, A, R>(this.source.enumerator(), this.collector.supplier().get(), this.collector.accumulator(), this.collector.finisher());
    }

    static final class CollectWithEnumerator<T, A, R>
    extends AtomicInteger
    implements AsyncEnumerator<R>,
    BiConsumer<Boolean, Throwable> {
        final AsyncEnumerator<T> source;
        final BiConsumer<A, T> accumulator;
        final Function<A, R> finisher;
        A collection;
        R result;
        CompletableFuture<Boolean> cf;
        volatile boolean cancelled;

        CollectWithEnumerator(AsyncEnumerator<T> source, A collection, BiConsumer<A, T> accumulator, Function<A, R> finisher) {
            this.source = source;
            this.collection = collection;
            this.accumulator = accumulator;
            this.finisher = finisher;
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            if (this.collection == null) {
                this.result = null;
                return AsyncEnumerable.FALSE;
            }
            this.cf = new CompletableFuture();
            this.collectSource();
            return this.cf;
        }

        @Override
        public R current() {
            return this.result;
        }

        void collectSource() {
            if (this.getAndIncrement() == 0) {
                do {
                    if (this.cancelled) {
                        return;
                    }
                    this.source.moveNext().whenComplete(this);
                } while (this.decrementAndGet() != 0);
            }
        }

        @Override
        public void accept(Boolean aBoolean, Throwable throwable) {
            if (throwable != null) {
                this.collection = null;
                this.cf.completeExceptionally(throwable);
                return;
            }
            if (aBoolean.booleanValue()) {
                this.accumulator.accept(this.collection, this.source.current());
                this.collectSource();
            } else {
                this.result = this.finisher.apply(this.collection);
                this.collection = null;
                this.cf.complete(true);
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.source.cancel();
        }
    }
}

