/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import hu.akarnokd.asyncenum.AsyncEnumeratorHelper;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;

final class AsyncConcatArray<T>
implements AsyncEnumerable<T> {
    final AsyncEnumerable<T>[] sources;

    AsyncConcatArray(AsyncEnumerable<T>[] sources) {
        this.sources = sources;
    }

    @Override
    public AsyncEnumerator<T> enumerator() {
        return new ConcatArrayEnumerator<T>(this.sources);
    }

    static final class ConcatArrayEnumerator<T>
    extends AtomicInteger
    implements AsyncEnumerator<T>,
    BiConsumer<Boolean, Throwable> {
        final AsyncEnumerable<T>[] sources;
        final AtomicReference<AsyncEnumerator<T>> currentEnumerator;
        CompletableFuture<Boolean> currentStage;
        int index;

        ConcatArrayEnumerator(AsyncEnumerable<T>[] sources) {
            this.sources = sources;
            this.currentEnumerator = new AtomicReference();
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            if (this.currentEnumerator.get() == null) {
                if (this.index == this.sources.length) {
                    return AsyncEnumerable.FALSE;
                }
                if (!AsyncEnumeratorHelper.replace(this.currentEnumerator, this.sources[this.index++].enumerator())) {
                    return AsyncEnumerable.CANCELLED;
                }
            }
            this.currentStage = new CompletableFuture();
            this.currentEnumerator.getPlain().moveNext().whenComplete(this);
            return this.currentStage;
        }

        @Override
        public T current() {
            return this.currentEnumerator.getPlain().current();
        }

        @Override
        public void accept(Boolean aBoolean, Throwable throwable) {
            if (throwable != null) {
                this.currentStage.completeExceptionally(throwable);
                return;
            }
            if (aBoolean.booleanValue()) {
                this.currentStage.complete(true);
            } else if (this.getAndIncrement() == 0) {
                do {
                    AsyncEnumerator<T> en;
                    if (this.index == this.sources.length) {
                        this.currentStage.complete(false);
                        break;
                    }
                    if (!AsyncEnumeratorHelper.replace(this.currentEnumerator, en = this.sources[this.index++].enumerator())) break;
                    en.moveNext().whenComplete(this);
                } while (this.decrementAndGet() != 0);
            }
        }

        @Override
        public void cancel() {
            AsyncEnumeratorHelper.cancel(this.currentEnumerator);
        }
    }
}

