/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import hu.akarnokd.asyncenum.AsyncEnumeratorHelper;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;

final class AsyncConcatMap<T, R>
implements AsyncEnumerable<R> {
    final AsyncEnumerable<T> source;
    final Function<? super T, ? extends AsyncEnumerable<? extends R>> mapper;

    public AsyncConcatMap(AsyncEnumerable<T> source, Function<? super T, ? extends AsyncEnumerable<? extends R>> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    @Override
    public AsyncEnumerator<R> enumerator() {
        return new ConcatMapEnumerator(this.source.enumerator(), this.mapper);
    }

    static final class ConcatMapEnumerator<T, R>
    implements AsyncEnumerator<R>,
    BiConsumer<Boolean, Throwable> {
        final AsyncEnumerator<T> source;
        final Function<? super T, ? extends AsyncEnumerable<? extends R>> mapper;
        final AtomicInteger wipMain;
        final AtomicInteger wipInner;
        final AtomicReference<AsyncEnumerator<R>> currentSource;
        volatile CompletableFuture<Boolean> completable;
        R current;

        ConcatMapEnumerator(AsyncEnumerator<T> source, Function<? super T, ? extends AsyncEnumerable<? extends R>> mapper) {
            this.source = source;
            this.mapper = mapper;
            this.currentSource = new AtomicReference();
            this.wipMain = new AtomicInteger();
            this.wipInner = new AtomicInteger();
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            CompletableFuture<Boolean> cf = new CompletableFuture<Boolean>();
            this.completable = cf;
            if (this.currentSource.getPlain() == null) {
                this.nextMain();
            } else {
                this.nextInner();
            }
            return cf;
        }

        @Override
        public R current() {
            return this.current;
        }

        @Override
        public void accept(Boolean aBoolean, Throwable throwable) {
            if (throwable != null) {
                this.source.cancel();
                this.completable.completeExceptionally(throwable);
                return;
            }
            if (aBoolean.booleanValue()) {
                this.current = this.currentSource.getPlain().current();
                this.completable.complete(true);
            } else {
                this.nextMain();
            }
        }

        public void acceptMain(Boolean aBoolean, Throwable throwable) {
            if (throwable != null) {
                this.completable.completeExceptionally(throwable);
                return;
            }
            if (aBoolean.booleanValue()) {
                if (AsyncEnumeratorHelper.replace(this.currentSource, this.mapper.apply(this.source.current()).enumerator())) {
                    this.nextInner();
                }
            } else {
                this.completable.complete(false);
            }
        }

        void nextMain() {
            if (this.wipMain.getAndIncrement() == 0) {
                do {
                    this.source.moveNext().whenComplete(this::acceptMain);
                } while (this.wipMain.decrementAndGet() != 0);
            }
        }

        void nextInner() {
            if (this.wipInner.getAndIncrement() == 0) {
                do {
                    this.currentSource.getPlain().moveNext().whenComplete(this);
                } while (this.wipInner.decrementAndGet() != 0);
            }
        }

        @Override
        public void cancel() {
            AsyncEnumeratorHelper.cancel(this.currentSource);
        }
    }
}

