/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEmitter;
import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

final class AsyncCreate<T>
implements AsyncEnumerable<T> {
    final Consumer<AsyncEmitter<T>> emitter;

    AsyncCreate(Consumer<AsyncEmitter<T>> emitter) {
        this.emitter = emitter;
    }

    @Override
    public AsyncEnumerator<T> enumerator() {
        CreateEnumerator en = new CreateEnumerator();
        this.emitter.accept(en);
        return en;
    }

    static final class CreateEnumerator<T>
    extends AtomicInteger
    implements AsyncEmitter<T>,
    AsyncEnumerator<T> {
        final AtomicReference<AutoCloseable> res;
        final ConcurrentLinkedQueue<T> queue = new ConcurrentLinkedQueue();
        T result;
        volatile boolean done;
        Throwable error;
        volatile CompletableFuture<Boolean> completable;
        AutoCloseable toRelease;

        CreateEnumerator() {
            this.res = new AtomicReference();
        }

        @Override
        public void cancel() {
            AutoCloseable c = this.res.getAndSet(Closed.INSTANCE);
            if (c != Closed.INSTANCE) {
                this.closeSilently(c);
            }
        }

        final void closeSilently(AutoCloseable c) {
            if (c != null) {
                try {
                    c.close();
                }
                catch (Exception ex) {
                    Thread t = Thread.currentThread();
                    t.getUncaughtExceptionHandler().uncaughtException(t, ex);
                }
            }
        }

        @Override
        public final void setResource(AutoCloseable resource) {
            block1: {
                AutoCloseable c;
                do {
                    if ((c = this.res.getAcquire()) != Closed.INSTANCE) continue;
                    this.closeSilently(resource);
                    break block1;
                } while (!this.res.compareAndSet(c, resource));
                this.closeSilently(c);
            }
        }

        @Override
        public final boolean isCancelled() {
            return this.res.getAcquire() == Closed.INSTANCE;
        }

        @Override
        public int emissionPending() {
            return this.queue.size();
        }

        @Override
        public void next(T item) {
            if (!this.isCancelled()) {
                this.queue.offer(item);
                this.drain();
            }
        }

        @Override
        public void error(Throwable error) {
            if (!this.isCancelled()) {
                this.toRelease = this.res.getAndSet(Closed.INSTANCE);
                this.error = error;
                this.done = true;
                this.drain();
            }
        }

        @Override
        public void stop() {
            if (!this.isCancelled()) {
                this.toRelease = this.res.getAndSet(Closed.INSTANCE);
                this.done = true;
                this.drain();
            }
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            this.result = null;
            CompletableFuture<Boolean> cf = new CompletableFuture<Boolean>();
            this.completable = cf;
            this.drain();
            return cf;
        }

        @Override
        public T current() {
            return this.result;
        }

        void drain() {
            if (this.getAndIncrement() == 0) {
                do {
                    CompletableFuture<Boolean> cf;
                    if ((cf = this.completable) == null) continue;
                    boolean d = this.done;
                    boolean empty = this.queue.isEmpty();
                    if (d && empty) {
                        this.completable = null;
                        Throwable ex = this.error;
                        if (ex == null) {
                            cf.complete(false);
                        } else {
                            cf.completeExceptionally(ex);
                        }
                        AutoCloseable c = this.toRelease;
                        this.toRelease = null;
                        if (c != null) {
                            this.closeSilently(c);
                        }
                        return;
                    }
                    if (empty) continue;
                    this.completable = null;
                    this.result = this.queue.poll();
                    cf.complete(true);
                } while (this.decrementAndGet() != 0);
            }
        }
    }

    static enum Closed implements AutoCloseable
    {
        INSTANCE;


        @Override
        public void close() {
        }
    }
}

