/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;

final class AsyncDistinct<T, K, C extends Collection<? super K>>
implements AsyncEnumerable<T> {
    final AsyncEnumerable<T> source;
    final Function<? super T, ? extends K> keySelector;
    final Supplier<C> setSupplier;

    AsyncDistinct(AsyncEnumerable<T> source, Function<? super T, ? extends K> keySelector, Supplier<C> setSupplier) {
        this.source = source;
        this.keySelector = keySelector;
        this.setSupplier = setSupplier;
    }

    @Override
    public AsyncEnumerator<T> enumerator() {
        return new DistinctEnumerator<T, K>(this.source.enumerator(), this.keySelector, (Collection)this.setSupplier.get());
    }

    static final class DistinctEnumerator<T, K>
    extends AtomicInteger
    implements AsyncEnumerator<T>,
    BiConsumer<Boolean, Throwable> {
        final AsyncEnumerator<T> source;
        final Function<? super T, ? extends K> keySelector;
        final Collection<? super K> set;
        CompletableFuture<Boolean> completable;
        T result;
        volatile boolean cancelled;

        DistinctEnumerator(AsyncEnumerator<T> source, Function<? super T, ? extends K> keySelector, Collection<? super K> set) {
            this.source = source;
            this.keySelector = keySelector;
            this.set = set;
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            this.result = null;
            CompletableFuture<Boolean> cf = new CompletableFuture<Boolean>();
            this.completable = cf;
            this.nextSource();
            return cf;
        }

        void nextSource() {
            if (this.getAndIncrement() == 0) {
                do {
                    if (this.cancelled) {
                        return;
                    }
                    this.source.moveNext().whenComplete(this);
                } while (this.decrementAndGet() != 0);
            }
        }

        @Override
        public T current() {
            return this.result;
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.source.cancel();
        }

        @Override
        public void accept(Boolean aBoolean, Throwable throwable) {
            if (throwable != null) {
                this.set.clear();
                this.completable.completeExceptionally(throwable);
                return;
            }
            if (aBoolean.booleanValue()) {
                T v = this.source.current();
                if (this.set.add(this.keySelector.apply(v))) {
                    this.result = v;
                    this.completable.complete(true);
                } else {
                    this.nextSource();
                }
            } else {
                this.set.clear();
                this.completable.complete(false);
            }
        }
    }
}

