/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;

final class AsyncDistinctUntilChanged<T, K>
implements AsyncEnumerable<T> {
    final AsyncEnumerable<T> source;
    final Function<? super T, ? extends K> keySelector;
    final BiPredicate<? super K, ? super K> comparer;

    AsyncDistinctUntilChanged(AsyncEnumerable<T> source, Function<? super T, ? extends K> keySelector, BiPredicate<? super K, ? super K> comparer) {
        this.source = source;
        this.keySelector = keySelector;
        this.comparer = comparer;
    }

    @Override
    public AsyncEnumerator<T> enumerator() {
        return new DistinctUntilChangedEnumerator<T, K>(this.source.enumerator(), this.keySelector, this.comparer);
    }

    static final class DistinctUntilChangedEnumerator<T, K>
    extends AtomicInteger
    implements AsyncEnumerator<T>,
    BiConsumer<Boolean, Throwable> {
        final AsyncEnumerator<T> source;
        final Function<? super T, ? extends K> keySelector;
        final BiPredicate<? super K, ? super K> comparer;
        CompletableFuture<Boolean> completable;
        volatile boolean cancelled;
        T result;
        boolean once;
        K currentKey;

        DistinctUntilChangedEnumerator(AsyncEnumerator<T> source, Function<? super T, ? extends K> keySelector, BiPredicate<? super K, ? super K> comparer) {
            this.source = source;
            this.keySelector = keySelector;
            this.comparer = comparer;
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            this.result = null;
            CompletableFuture<Boolean> cf = new CompletableFuture<Boolean>();
            this.completable = cf;
            this.nextSource();
            return cf;
        }

        void nextSource() {
            if (this.getAndIncrement() == 0) {
                do {
                    if (this.cancelled) {
                        return;
                    }
                    this.source.moveNext().whenComplete(this);
                } while (this.decrementAndGet() != 0);
            }
        }

        @Override
        public T current() {
            return this.result;
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.source.cancel();
        }

        @Override
        public void accept(Boolean aBoolean, Throwable throwable) {
            if (throwable != null) {
                this.currentKey = null;
                this.completable.completeExceptionally(throwable);
                return;
            }
            if (aBoolean.booleanValue()) {
                T v = this.source.current();
                if (this.once) {
                    K prevKey = this.currentKey;
                    K nextKey = this.keySelector.apply(v);
                    if (this.comparer.test(prevKey, nextKey)) {
                        this.currentKey = nextKey;
                        this.nextSource();
                    } else {
                        this.currentKey = nextKey;
                        this.result = v;
                        this.completable.complete(true);
                    }
                } else {
                    this.once = true;
                    this.currentKey = this.keySelector.apply(v);
                    this.result = v;
                    this.completable.complete(true);
                }
            } else {
                this.currentKey = null;
                this.completable.complete(false);
            }
        }
    }
}

