/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;

final class AsyncDoFinally<T>
implements AsyncEnumerable<T> {
    final AsyncEnumerable<T> source;
    final Runnable onFinally;

    AsyncDoFinally(AsyncEnumerable<T> source, Runnable onFinally) {
        this.source = source;
        this.onFinally = onFinally;
    }

    @Override
    public AsyncEnumerator<T> enumerator() {
        return new DoFinallyEnumerator<T>(this.source.enumerator(), this.onFinally);
    }

    static final class DoFinallyEnumerator<T>
    extends AtomicBoolean
    implements AsyncEnumerator<T>,
    BiConsumer<Boolean, Throwable> {
        final AsyncEnumerator<T> source;
        final Runnable onFinally;
        CompletableFuture<Boolean> completable;
        T result;

        DoFinallyEnumerator(AsyncEnumerator<T> source, Runnable onFinally) {
            this.source = source;
            this.onFinally = onFinally;
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            this.result = null;
            CompletableFuture<Boolean> cf = new CompletableFuture<Boolean>();
            this.completable = cf;
            this.source.moveNext().whenComplete(this);
            return cf;
        }

        @Override
        public T current() {
            return this.result;
        }

        @Override
        public void cancel() {
            this.source.cancel();
            this.runFinally();
        }

        void runFinally() {
            if (this.compareAndSet(false, true)) {
                this.onFinally.run();
            }
        }

        @Override
        public void accept(Boolean aBoolean, Throwable throwable) {
            if (throwable != null) {
                this.completable.completeExceptionally(throwable);
                this.runFinally();
                return;
            }
            if (aBoolean.booleanValue()) {
                this.result = this.source.current();
                this.completable.complete(true);
            } else {
                this.completable.complete(false);
                this.runFinally();
            }
        }
    }
}

