/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

final class AsyncDoOn<T>
implements AsyncEnumerable<T> {
    final AsyncEnumerable<T> source;
    final Consumer<? super T> onNext;
    final Consumer<? super Throwable> onError;
    final Runnable onComplete;

    AsyncDoOn(AsyncEnumerable<T> source, Consumer<? super T> onNext, Consumer<? super Throwable> onError, Runnable onComplete) {
        this.source = source;
        this.onNext = onNext;
        this.onError = onError;
        this.onComplete = onComplete;
    }

    @Override
    public AsyncEnumerator<T> enumerator() {
        return new DoOnEnumerator<T>(this.source.enumerator(), this.onNext, this.onError, this.onComplete);
    }

    static final class DoOnEnumerator<T>
    implements AsyncEnumerator<T>,
    BiConsumer<Boolean, Throwable> {
        final AsyncEnumerator<T> source;
        final Consumer<? super T> onNext;
        final Consumer<? super Throwable> onError;
        final Runnable onComplete;
        CompletableFuture<Boolean> completable;
        T result;

        DoOnEnumerator(AsyncEnumerator<T> source, Consumer<? super T> onNext, Consumer<? super Throwable> onError, Runnable onComplete) {
            this.source = source;
            this.onNext = onNext;
            this.onError = onError;
            this.onComplete = onComplete;
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            this.result = null;
            CompletableFuture<Boolean> cf = new CompletableFuture<Boolean>();
            this.completable = cf;
            this.source.moveNext().whenComplete(this);
            return cf;
        }

        @Override
        public T current() {
            return this.result;
        }

        @Override
        public void cancel() {
            this.source.cancel();
        }

        @Override
        public void accept(Boolean aBoolean, Throwable throwable) {
            if (throwable != null) {
                this.onError.accept(throwable);
                this.completable.completeExceptionally(throwable);
                return;
            }
            if (aBoolean.booleanValue()) {
                T r = this.source.current();
                this.result = r;
                this.onNext.accept(r);
                this.completable.complete(true);
            } else {
                this.onComplete.run();
                this.completable.complete(false);
            }
        }
    }
}

