/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncBlockingFirst;
import hu.akarnokd.asyncenum.AsyncBlockingIterable;
import hu.akarnokd.asyncenum.AsyncBlockingLast;
import hu.akarnokd.asyncenum.AsyncCache;
import hu.akarnokd.asyncenum.AsyncCollect;
import hu.akarnokd.asyncenum.AsyncCollectWith;
import hu.akarnokd.asyncenum.AsyncConcatArray;
import hu.akarnokd.asyncenum.AsyncConcatMap;
import hu.akarnokd.asyncenum.AsyncCreate;
import hu.akarnokd.asyncenum.AsyncDefer;
import hu.akarnokd.asyncenum.AsyncDistinct;
import hu.akarnokd.asyncenum.AsyncDistinctUntilChanged;
import hu.akarnokd.asyncenum.AsyncDoFinally;
import hu.akarnokd.asyncenum.AsyncDoOn;
import hu.akarnokd.asyncenum.AsyncDoOnCancel;
import hu.akarnokd.asyncenum.AsyncEmitter;
import hu.akarnokd.asyncenum.AsyncEmpty;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import hu.akarnokd.asyncenum.AsyncError;
import hu.akarnokd.asyncenum.AsyncFilter;
import hu.akarnokd.asyncenum.AsyncFirst;
import hu.akarnokd.asyncenum.AsyncFlatMap;
import hu.akarnokd.asyncenum.AsyncForEach;
import hu.akarnokd.asyncenum.AsyncFromArray;
import hu.akarnokd.asyncenum.AsyncFromCallable;
import hu.akarnokd.asyncenum.AsyncFromCharSequence;
import hu.akarnokd.asyncenum.AsyncFromCompletionStage;
import hu.akarnokd.asyncenum.AsyncFromFlowPublisher;
import hu.akarnokd.asyncenum.AsyncFromIterable;
import hu.akarnokd.asyncenum.AsyncFromStream;
import hu.akarnokd.asyncenum.AsyncGenerate;
import hu.akarnokd.asyncenum.AsyncGroupBy;
import hu.akarnokd.asyncenum.AsyncIgnoreElements;
import hu.akarnokd.asyncenum.AsyncInterval;
import hu.akarnokd.asyncenum.AsyncJust;
import hu.akarnokd.asyncenum.AsyncLast;
import hu.akarnokd.asyncenum.AsyncMap;
import hu.akarnokd.asyncenum.AsyncMax;
import hu.akarnokd.asyncenum.AsyncNever;
import hu.akarnokd.asyncenum.AsyncObserveOn;
import hu.akarnokd.asyncenum.AsyncOnErrorResume;
import hu.akarnokd.asyncenum.AsyncPublish;
import hu.akarnokd.asyncenum.AsyncRange;
import hu.akarnokd.asyncenum.AsyncReduce;
import hu.akarnokd.asyncenum.AsyncReduceWith;
import hu.akarnokd.asyncenum.AsyncRepeat;
import hu.akarnokd.asyncenum.AsyncRepeatCallable;
import hu.akarnokd.asyncenum.AsyncRepeatItem;
import hu.akarnokd.asyncenum.AsyncRepeatWhen;
import hu.akarnokd.asyncenum.AsyncRetry;
import hu.akarnokd.asyncenum.AsyncRetryWhen;
import hu.akarnokd.asyncenum.AsyncSkip;
import hu.akarnokd.asyncenum.AsyncSkipLast;
import hu.akarnokd.asyncenum.AsyncSkipWhile;
import hu.akarnokd.asyncenum.AsyncSubscribeOn;
import hu.akarnokd.asyncenum.AsyncSumInt;
import hu.akarnokd.asyncenum.AsyncSumLong;
import hu.akarnokd.asyncenum.AsyncSwitchIfEmpty;
import hu.akarnokd.asyncenum.AsyncTake;
import hu.akarnokd.asyncenum.AsyncTakeLast;
import hu.akarnokd.asyncenum.AsyncTakeUntil;
import hu.akarnokd.asyncenum.AsyncTakeUntilPredicate;
import hu.akarnokd.asyncenum.AsyncTakeWhile;
import hu.akarnokd.asyncenum.AsyncTimeoutTimed;
import hu.akarnokd.asyncenum.AsyncTimer;
import hu.akarnokd.asyncenum.AsyncToFlowPublisher;
import hu.akarnokd.asyncenum.AsyncUsing;
import hu.akarnokd.asyncenum.AsyncZipArray;
import hu.akarnokd.asyncenum.CancelledEnumeratorException;
import hu.akarnokd.asyncenum.GroupedAsyncEnumerable;
import hu.akarnokd.asyncenum.SyncEmitter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

@FunctionalInterface
public interface AsyncEnumerable<T> {
    public static final CompletionStage<Boolean> TRUE = CompletableFuture.completedStage(true);
    public static final CompletionStage<Boolean> FALSE = CompletableFuture.completedStage(false);
    public static final CompletionStage<Boolean> CANCELLED = CompletableFuture.failedStage(new CancelledEnumeratorException());

    public AsyncEnumerator<T> enumerator();

    public static AsyncEnumerable<Integer> range(int start, int count) {
        return new AsyncRange(start, count);
    }

    public static <T> AsyncEnumerable<T> empty() {
        return AsyncEmpty.instance();
    }

    @SafeVarargs
    public static <T> AsyncEnumerable<T> fromArray(T ... array) {
        return new AsyncFromArray<T>(array);
    }

    public static <T> AsyncEnumerable<T> fromIterable(Iterable<T> iterable) {
        return new AsyncFromIterable<T>(iterable);
    }

    @SafeVarargs
    public static <T> AsyncEnumerable<T> concatArray(AsyncEnumerable<T> ... sources) {
        return new AsyncConcatArray<T>(sources);
    }

    public static AsyncEnumerable<Integer> characters(CharSequence chars) {
        return new AsyncFromCharSequence(chars);
    }

    public static <T> AsyncEnumerable<T> fromCompletionStage(CompletionStage<T> stage) {
        return new AsyncFromCompletionStage<T>(stage);
    }

    public static AsyncEnumerable<Long> timer(long time, TimeUnit unit, ScheduledExecutorService executor) {
        return new AsyncTimer(time, unit, executor);
    }

    public static <T> AsyncEnumerable<T> just(T item) {
        return new AsyncJust<T>(item);
    }

    public static <T> AsyncEnumerable<T> fromFlowPublisher(Flow.Publisher<T> source) {
        return new AsyncFromFlowPublisher<T>(source);
    }

    public static <T> AsyncEnumerable<T> never() {
        return AsyncNever.instance();
    }

    public static <T> AsyncEnumerable<T> error(Throwable error) {
        return new AsyncError(error);
    }

    public static <T> AsyncEnumerable<T> defer(Supplier<? extends AsyncEnumerable<? extends T>> supplier) {
        return new AsyncDefer(supplier);
    }

    @SafeVarargs
    public static <T, R> AsyncEnumerable<R> zipArray(Function<? super Object[], ? extends R> zipper, AsyncEnumerable<? extends T> ... sources) {
        return new AsyncZipArray<T, R>(sources, zipper);
    }

    @SafeVarargs
    public static <T> AsyncEnumerable<T> mergeArray(AsyncEnumerable<? extends T> ... sources) {
        return AsyncEnumerable.fromArray(sources).flatMap(v -> v);
    }

    public static AsyncEnumerable<Long> interval(long period, TimeUnit unit, ScheduledExecutorService executor) {
        return AsyncEnumerable.interval(period, period, unit, executor);
    }

    public static AsyncEnumerable<Long> interval(long initialDelay, long period, TimeUnit unit, ScheduledExecutorService executor) {
        return new AsyncInterval(initialDelay, period, unit, executor);
    }

    public static <T> AsyncEnumerable<T> fromCallable(Callable<? extends T> callable) {
        return new AsyncFromCallable<T>(callable);
    }

    public static <T> AsyncEnumerable<T> repeatItem(T item) {
        return new AsyncRepeatItem<T>(item);
    }

    public static <T> AsyncEnumerable<T> repeatCallable(Callable<? extends T> callable) {
        return new AsyncRepeatCallable<T>(callable);
    }

    public static <T> AsyncEnumerable<T> fromStream(Stream<T> stream) {
        return new AsyncFromStream<T>(stream);
    }

    public static <T> AsyncEnumerable<T> generate(Consumer<SyncEmitter<T>> generator) {
        return AsyncEnumerable.generate(() -> null, (s, e) -> {
            generator.accept((SyncEmitter)e);
            return s;
        }, s -> {});
    }

    public static <T, S> AsyncEnumerable<T> generate(Supplier<S> state, BiFunction<S, SyncEmitter<T>, S> generator) {
        return AsyncEnumerable.generate(state, generator, s -> {});
    }

    public static <T, S> AsyncEnumerable<T> generate(Supplier<S> state, BiFunction<S, SyncEmitter<T>, S> generator, Consumer<? super S> releaseState) {
        return new AsyncGenerate<T, S>(state, generator, releaseState);
    }

    public static <T, U> AsyncEnumerable<T> using(Supplier<U> resource, Function<? super U, ? extends AsyncEnumerable<T>> handler, Consumer<? super U> releaseResource) {
        return new AsyncUsing(resource, handler, releaseResource);
    }

    public static <T> AsyncEnumerable<T> create(Consumer<AsyncEmitter<T>> emitter) {
        return new AsyncCreate<T>(emitter);
    }

    default public <R> AsyncEnumerable<R> flatMap(Function<? super T, ? extends AsyncEnumerable<? extends R>> mapper) {
        return new AsyncFlatMap(this, mapper);
    }

    default public AsyncEnumerable<T> take(long n) {
        return new AsyncTake(this, n);
    }

    default public AsyncEnumerable<T> skip(long n) {
        return new AsyncSkip(this, n);
    }

    default public <R> AsyncEnumerable<R> map(Function<? super T, ? extends R> mapper) {
        return new AsyncMap<T, R>(this, mapper);
    }

    default public AsyncEnumerable<T> filter(Predicate<? super T> predicate) {
        return new AsyncFilter<T>(this, predicate);
    }

    default public <C> AsyncEnumerable<C> collect(Supplier<C> collection, BiConsumer<C, T> collector) {
        return new AsyncCollect<T, C>(this, collection, collector);
    }

    default public AsyncEnumerable<Long> sumLong(Function<? super T, ? extends Number> selector) {
        return new AsyncSumLong<T>(this, selector);
    }

    default public AsyncEnumerable<Integer> sumInt(Function<? super T, ? extends Number> selector) {
        return new AsyncSumInt<T>(this, selector);
    }

    default public AsyncEnumerable<T> min(Comparator<? super T> comparator) {
        return new AsyncMax<T>(this, comparator.reversed());
    }

    default public AsyncEnumerable<T> max(Comparator<? super T> comparator) {
        return new AsyncMax<T>(this, comparator);
    }

    default public AsyncEnumerable<List<T>> toList() {
        return this.collect(ArrayList::new, List::add);
    }

    default public AsyncEnumerable<T> subscribeOn(Executor executor) {
        return new AsyncSubscribeOn(this, executor);
    }

    default public AsyncEnumerable<T> observeOn(Executor executor) {
        return new AsyncObserveOn(this, executor);
    }

    default public <U> AsyncEnumerable<T> takeUntil(AsyncEnumerable<U> other) {
        return new AsyncTakeUntil(this, other);
    }

    default public <R> AsyncEnumerable<R> concatMap(Function<? super T, ? extends AsyncEnumerable<? extends R>> mapper) {
        return new AsyncConcatMap(this, mapper);
    }

    default public Flow.Publisher<T> toFlowPublisher() {
        return new AsyncToFlowPublisher(this);
    }

    default public AsyncEnumerable<T> timeout(long timeout, TimeUnit unit, ScheduledExecutorService executor) {
        return new AsyncTimeoutTimed(this, timeout, unit, executor, null);
    }

    default public AsyncEnumerable<T> timeout(long timeout, TimeUnit unit, ScheduledExecutorService executor, AsyncEnumerable<T> fallback) {
        return new AsyncTimeoutTimed<T>(this, timeout, unit, executor, Objects.requireNonNull(fallback, "fallback == null"));
    }

    default public AsyncEnumerable<T> onErrorResume(Function<? super Throwable, ? extends AsyncEnumerable<? extends T>> resumeMapper) {
        return new AsyncOnErrorResume(this, resumeMapper);
    }

    default public <R> R to(Function<? super AsyncEnumerable<T>, R> converter) {
        return converter.apply(this);
    }

    default public <R> AsyncEnumerable<R> compose(Function<? super AsyncEnumerable<T>, ? extends AsyncEnumerable<R>> composer) {
        return this.to(composer);
    }

    default public AsyncEnumerable<T> concatWith(AsyncEnumerable<T> other) {
        return AsyncEnumerable.concatArray(this, other);
    }

    default public AsyncEnumerable<T> startWith(AsyncEnumerable<T> other) {
        return AsyncEnumerable.concatArray(other, this);
    }

    default public <U, R> AsyncEnumerable<R> zipWith(AsyncEnumerable<U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        return AsyncEnumerable.zipArray(a -> zipper.apply(a[0], a[1]), this, other);
    }

    default public AsyncEnumerable<T> mergeWith(AsyncEnumerable<T> other) {
        return AsyncEnumerable.mergeArray(this, other);
    }

    default public AsyncEnumerable<T> doOnNext(Consumer<? super T> onNext) {
        return new AsyncDoOn<T>(this, onNext, t -> {}, () -> {});
    }

    default public AsyncEnumerable<T> doOnError(Consumer<? super Throwable> onError) {
        return new AsyncDoOn<Object>(this, t -> {}, onError, () -> {});
    }

    default public AsyncEnumerable<T> doOnComplete(Runnable onComplete) {
        return new AsyncDoOn<Object>(this, t -> {}, t -> {}, onComplete);
    }

    default public AsyncEnumerable<T> doFinally(Runnable onFinally) {
        return new AsyncDoFinally(this, onFinally);
    }

    default public AsyncEnumerable<T> ignoreElements() {
        return new AsyncIgnoreElements(this);
    }

    default public AsyncEnumerable<T> doOnCancel(Runnable onCancel) {
        return new AsyncDoOnCancel(this, onCancel);
    }

    default public AsyncEnumerable<T> repeat(long times) {
        return this.repeat(times, () -> false);
    }

    default public AsyncEnumerable<T> repeat(BooleanSupplier stop) {
        return this.repeat(Long.MAX_VALUE, stop);
    }

    default public AsyncEnumerable<T> repeat(long times, BooleanSupplier stop) {
        return new AsyncRepeat(this, times, stop);
    }

    default public AsyncEnumerable<T> retry(long times) {
        return this.retry(times, e -> true);
    }

    default public AsyncEnumerable<T> retry(Predicate<? super Throwable> predicate) {
        return this.retry(Long.MAX_VALUE, predicate);
    }

    default public AsyncEnumerable<T> retry(long times, Predicate<? super Throwable> predicate) {
        return new AsyncRetry(this, times, predicate);
    }

    default public AsyncEnumerable<T> repeatWhen(Supplier<? extends CompletionStage<Boolean>> completer) {
        return this.repeatWhen(() -> null, s -> (CompletionStage)completer.get());
    }

    default public <S> AsyncEnumerable<T> repeatWhen(Supplier<S> stateSupplier, Function<? super S, ? extends CompletionStage<Boolean>> completer) {
        return new AsyncRepeatWhen(this, stateSupplier, completer);
    }

    default public <S> AsyncEnumerable<T> retryWhen(Function<? super Throwable, ? extends CompletionStage<Boolean>> completer) {
        return this.retryWhen(() -> null, (s, e) -> (CompletionStage)completer.apply((Throwable)e));
    }

    default public <S> AsyncEnumerable<T> retryWhen(Supplier<S> stateSupplier, BiFunction<? super S, ? super Throwable, ? extends CompletionStage<Boolean>> completer) {
        return new AsyncRetryWhen(this, stateSupplier, completer);
    }

    default public <K> AsyncEnumerable<GroupedAsyncEnumerable<T, K>> groupBy(Function<? super T, ? extends K> keySelector) {
        return this.groupBy(keySelector, v -> v);
    }

    default public <K, V> AsyncEnumerable<GroupedAsyncEnumerable<V, K>> groupBy(Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector) {
        return new AsyncGroupBy<T, K, V>(this, keySelector, valueSelector);
    }

    default public AsyncEnumerable<T> skipWhile(Predicate<? super T> predicate) {
        return new AsyncSkipWhile<T>(this, predicate);
    }

    default public AsyncEnumerable<T> takeWhile(Predicate<? super T> predicate) {
        return new AsyncTakeWhile<T>(this, predicate);
    }

    default public AsyncEnumerable<T> takeUntil(Predicate<? super T> stopPredicate) {
        return new AsyncTakeUntilPredicate<T>(this, stopPredicate);
    }

    default public <A, R> AsyncEnumerable<R> collect(Collector<T, A, R> collector) {
        return new AsyncCollectWith<T, A, R>(this, collector);
    }

    default public AsyncEnumerable<T> cache() {
        return new AsyncCache(this);
    }

    default public AsyncEnumerable<T> distinct() {
        return this.distinct(v -> v, HashSet::new);
    }

    default public <K> AsyncEnumerable<T> distinct(Function<? super T, ? extends K> keySelector) {
        return this.distinct(keySelector, HashSet::new);
    }

    default public <K> AsyncEnumerable<T> distinct(Function<? super T, ? extends K> keySelector, Supplier<? extends Collection<? super K>> setSupplier) {
        return new AsyncDistinct<T, K, Collection<? super K>>(this, keySelector, setSupplier);
    }

    default public AsyncEnumerable<T> distinctUntilChanged() {
        return this.distinctUntilChanged(v -> v, Objects::equals);
    }

    default public <K> AsyncEnumerable<T> distinctUntilChanged(Function<? super T, ? extends K> keySelector) {
        return this.distinctUntilChanged(keySelector, Objects::equals);
    }

    default public <K> AsyncEnumerable<T> distinctUntilChanged(Function<? super T, ? extends K> keySelector, BiPredicate<? super K, ? super K> comparer) {
        return new AsyncDistinctUntilChanged<T, K>(this, keySelector, comparer);
    }

    default public AsyncEnumerable<T> reduce(BiFunction<T, T, T> reducer) {
        return new AsyncReduce<T>(this, reducer);
    }

    default public <R> AsyncEnumerable<R> reduce(Supplier<R> initial, BiFunction<R, T, R> reducer) {
        return new AsyncReduceWith<T, R>(this, initial, reducer);
    }

    default public AsyncEnumerable<T> skipLast(int n) {
        if (n <= 0) {
            return this;
        }
        return new AsyncSkipLast(this, n);
    }

    default public AsyncEnumerable<T> takeLast(int n) {
        if (n <= 0) {
            return this.ignoreElements();
        }
        return new AsyncTakeLast(this, n);
    }

    default public <R> AsyncEnumerable<R> publish(Function<? super AsyncEnumerable<T>, ? extends AsyncEnumerable<R>> handler) {
        return new AsyncPublish(this, handler);
    }

    default public AsyncEnumerable<T> switchIfEmpty(AsyncEnumerable<T> fallback) {
        return new AsyncSwitchIfEmpty<T>(this, fallback);
    }

    default public AsyncEnumerable<T> first() {
        return new AsyncFirst(this);
    }

    default public AsyncEnumerable<T> last() {
        return new AsyncLast(this);
    }

    default public CompletionStage<Boolean> forEach(Consumer<? super T> consumer) {
        return AsyncForEach.forEach(this.enumerator(), consumer);
    }

    default public T blockingFirst() {
        return AsyncBlockingFirst.blockingFirst(this.enumerator());
    }

    default public T blockingLast() {
        AsyncBlockingLast<T> bl = new AsyncBlockingLast<T>(this.enumerator());
        bl.moveNext();
        return bl.blockingGet();
    }

    default public Iterable<T> blockingIterable() {
        return new AsyncBlockingIterable(this);
    }

    default public Stream<T> blockingStream() {
        Iterator<T> it = this.blockingIterable().iterator();
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 0), false).onClose((Runnable)((Object)it));
    }

    default public Optional<T> blockingFirstOptional() {
        return AsyncBlockingFirst.blockingFirstOptional(this.enumerator());
    }

    default public Optional<T> blockingLastOptional() {
        AsyncBlockingLast<T> bl = new AsyncBlockingLast<T>(this.enumerator());
        bl.moveNext();
        return bl.blockingGetOptional();
    }
}

