/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;

enum AsyncEnumeratorHelper implements AsyncEnumerator<Object>
{
    CANCELLED;


    @Override
    public CompletionStage<Boolean> moveNext() {
        return AsyncEnumerable.CANCELLED;
    }

    @Override
    public Object current() {
        return null;
    }

    @Override
    public void cancel() {
    }

    static <T> boolean cancel(AtomicReference<AsyncEnumerator<T>> target) {
        AsyncEnumerator current = target.getAndSet(CANCELLED);
        if (current != CANCELLED) {
            if (current != null) {
                current.cancel();
            }
            return true;
        }
        return false;
    }

    static <T> boolean replace(AtomicReference<AsyncEnumerator<T>> target, AsyncEnumerator<T> next) {
        AsyncEnumerator<T> current;
        do {
            if ((current = target.getAcquire()) != CANCELLED) continue;
            next.cancel();
            return false;
        } while (!target.compareAndSet(current, next));
        return true;
    }

    static boolean isCancelled(AsyncEnumerator<?> enumerator) {
        return enumerator == CANCELLED;
    }
}

