/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Predicate;

final class AsyncFilter<T>
implements AsyncEnumerable<T> {
    final AsyncEnumerable<T> source;
    final Predicate<? super T> predicate;

    AsyncFilter(AsyncEnumerable<T> source, Predicate<? super T> predicate) {
        this.source = source;
        this.predicate = predicate;
    }

    @Override
    public AsyncEnumerator<T> enumerator() {
        return new FilterEnumerator<T>(this.source.enumerator(), this.predicate);
    }

    static final class FilterEnumerator<T>
    extends AtomicInteger
    implements AsyncEnumerator<T>,
    BiConsumer<Boolean, Throwable> {
        final AsyncEnumerator<T> source;
        final Predicate<? super T> predicate;
        CompletableFuture<Boolean> current;
        T currentItem;

        FilterEnumerator(AsyncEnumerator<T> source, Predicate<? super T> predicate) {
            this.source = source;
            this.predicate = predicate;
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            this.current = new CompletableFuture();
            this.moveNextSource();
            return this.current;
        }

        @Override
        public T current() {
            return this.currentItem;
        }

        void moveNextSource() {
            if (this.getAndIncrement() == 0) {
                do {
                    this.source.moveNext().whenComplete(this);
                } while (this.decrementAndGet() != 0);
            }
        }

        @Override
        public void accept(Boolean aBoolean, Throwable throwable) {
            if (throwable != null) {
                this.currentItem = null;
                this.current.completeExceptionally(throwable);
                return;
            }
            if (aBoolean.booleanValue()) {
                T v = this.source.current();
                if (this.predicate.test(v)) {
                    this.currentItem = v;
                    this.current.complete(true);
                } else {
                    this.currentItem = null;
                    this.moveNextSource();
                }
            } else {
                this.current.complete(false);
            }
        }

        @Override
        public void cancel() {
            this.source.cancel();
        }
    }
}

