/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import java.util.concurrent.CompletionStage;

final class AsyncFirst<T>
implements AsyncEnumerable<T> {
    final AsyncEnumerable<T> source;

    AsyncFirst(AsyncEnumerable<T> source) {
        this.source = source;
    }

    @Override
    public AsyncEnumerator<T> enumerator() {
        return new FirstEnumerator<T>(this.source.enumerator());
    }

    static final class FirstEnumerator<T>
    implements AsyncEnumerator<T> {
        final AsyncEnumerator<T> source;
        boolean once;

        FirstEnumerator(AsyncEnumerator<T> source) {
            this.source = source;
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            if (this.once) {
                this.source.cancel();
                return AsyncEnumerable.FALSE;
            }
            this.once = true;
            return this.source.moveNext();
        }

        @Override
        public T current() {
            return this.source.current();
        }

        @Override
        public void cancel() {
            this.source.cancel();
        }
    }
}

