/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

final class AsyncForEach {
    AsyncForEach() {
    }

    static <T> CompletionStage<Boolean> forEach(AsyncEnumerator<T> enumerator, Consumer<? super T> onValue) {
        CompletableFuture<Boolean> completion = new CompletableFuture<Boolean>();
        new ForEachTrampoline<T>(completion, enumerator, onValue).moveNext();
        return completion;
    }

    static final class ForEachTrampoline<T>
    extends AtomicInteger
    implements BiConsumer<Boolean, Throwable> {
        final CompletableFuture<Boolean> completion;
        final AsyncEnumerator<T> enumerator;
        final Consumer<? super T> onValue;

        ForEachTrampoline(CompletableFuture<Boolean> completion, AsyncEnumerator<T> enumerator, Consumer<? super T> onValue) {
            this.completion = completion;
            this.enumerator = enumerator;
            this.onValue = onValue;
        }

        @Override
        public void accept(Boolean r, Throwable e) {
            if (e != null) {
                this.completion.completeExceptionally(e);
                return;
            }
            if (r.booleanValue()) {
                this.onValue.accept(this.enumerator.current());
                this.moveNext();
            } else {
                this.completion.complete(true);
            }
        }

        void moveNext() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            do {
                CompletionStage<Boolean> next = this.enumerator.moveNext();
                next.whenComplete(this);
            } while (this.decrementAndGet() != 0);
        }
    }
}

