/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import java.util.concurrent.CompletionStage;

final class AsyncFromArray<T>
implements AsyncEnumerable<T> {
    final T[] array;

    AsyncFromArray(T[] array) {
        this.array = array;
    }

    @Override
    public AsyncEnumerator<T> enumerator() {
        return new FromArrayEnumerator<T>(this.array);
    }

    static final class FromArrayEnumerator<T>
    implements AsyncEnumerator<T> {
        final T[] array;
        int index;
        T current;

        FromArrayEnumerator(T[] array) {
            this.array = array;
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            int idx = this.index;
            if (idx == this.array.length) {
                this.current = null;
                return AsyncEnumerable.FALSE;
            }
            this.current = this.array[idx];
            this.index = idx + 1;
            return AsyncEnumerable.TRUE;
        }

        @Override
        public T current() {
            return this.current;
        }

        @Override
        public void cancel() {
        }
    }
}

