/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import java.util.concurrent.CompletionStage;

final class AsyncFromCharSequence
implements AsyncEnumerable<Integer> {
    final CharSequence array;

    AsyncFromCharSequence(CharSequence array) {
        this.array = array;
    }

    @Override
    public AsyncEnumerator<Integer> enumerator() {
        return new FromCharSequenceEnumerator(this.array);
    }

    static final class FromCharSequenceEnumerator
    implements AsyncEnumerator<Integer> {
        final CharSequence array;
        int index;
        Integer current;

        FromCharSequenceEnumerator(CharSequence array) {
            this.array = array;
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            int idx = this.index;
            if (idx == this.array.length()) {
                this.current = null;
                return AsyncEnumerable.FALSE;
            }
            this.current = this.array.charAt(idx);
            this.index = idx + 1;
            return AsyncEnumerable.TRUE;
        }

        @Override
        public Integer current() {
            return this.current;
        }

        @Override
        public void cancel() {
        }
    }
}

