/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;

final class AsyncFromCompletionStage<T>
implements AsyncEnumerable<T> {
    final CompletionStage<T> source;

    AsyncFromCompletionStage(CompletionStage<T> source) {
        this.source = source;
    }

    @Override
    public AsyncEnumerator<T> enumerator() {
        return new FromCompletionStageAsyncEnumerable<T>(this.source);
    }

    static final class FromCompletionStageAsyncEnumerable<T>
    implements AsyncEnumerator<T>,
    BiConsumer<T, Throwable> {
        final CompletionStage<T> stage;
        CompletableFuture<Boolean> completable;
        boolean once;
        T result;

        FromCompletionStageAsyncEnumerable(CompletionStage<T> stage) {
            this.stage = stage;
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            if (this.once) {
                this.result = null;
                return AsyncEnumerable.FALSE;
            }
            this.once = true;
            CompletableFuture<Boolean> cf = new CompletableFuture<Boolean>();
            this.completable = cf;
            this.stage.whenComplete(this);
            return cf;
        }

        @Override
        public T current() {
            return this.result;
        }

        @Override
        public void accept(T t, Throwable throwable) {
            if (throwable != null) {
                this.completable.completeExceptionally(throwable);
            } else {
                this.result = t;
                this.completable.complete(true);
            }
        }

        @Override
        public void cancel() {
        }
    }
}

