/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class AsyncFromFlowPublisher<T>
implements AsyncEnumerable<T> {
    final Flow.Publisher<T> source;

    AsyncFromFlowPublisher(Flow.Publisher<T> source) {
        this.source = source;
    }

    @Override
    public AsyncEnumerator<T> enumerator() {
        FromFlowPublisherEnumerator subscriber = new FromFlowPublisherEnumerator();
        this.source.subscribe(subscriber);
        return subscriber;
    }

    static enum CancelledSubscription implements Flow.Subscription
    {
        CANCELLED;


        @Override
        public void request(long n) {
        }

        @Override
        public void cancel() {
        }
    }

    static final class FromFlowPublisherEnumerator<T>
    extends AtomicInteger
    implements AsyncEnumerator<T>,
    Flow.Subscriber<T> {
        final AtomicReference<Flow.Subscription> upstream = new AtomicReference();
        final AtomicLong requested = new AtomicLong();
        volatile T item;
        volatile boolean done;
        Throwable error;
        T current;
        volatile CompletableFuture<Boolean> completable;

        FromFlowPublisherEnumerator() {
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            this.current = null;
            CompletableFuture<Boolean> cf = new CompletableFuture<Boolean>();
            this.completable = cf;
            this.deferredRequestOne();
            this.drain();
            return cf;
        }

        @Override
        public T current() {
            return this.current;
        }

        @Override
        public void cancel() {
            Flow.Subscription current = this.upstream.getAndSet(CancelledSubscription.CANCELLED);
            if (current != null && current != CancelledSubscription.CANCELLED) {
                current.cancel();
            }
        }

        void deferredRequestOne() {
            Flow.Subscription current = this.upstream.get();
            if (current != null) {
                current.request(1L);
            } else {
                long r;
                this.requested.getAndIncrement();
                current = this.upstream.get();
                if (current != null && (r = this.requested.getAndSet(0L)) != 0L) {
                    current.request(r);
                }
            }
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            Objects.requireNonNull(subscription, "subscription == null");
            if (this.upstream.compareAndSet(null, subscription)) {
                long r = this.requested.getAndSet(0L);
                if (r != 0L) {
                    subscription.request(r);
                }
            } else {
                subscription.cancel();
            }
        }

        @Override
        public void onNext(T item) {
            this.item = item;
            this.drain();
        }

        @Override
        public void onError(Throwable throwable) {
            this.error = throwable;
            this.done = true;
            this.drain();
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() == 0) {
                do {
                    CompletableFuture<Boolean> cf;
                    if ((cf = this.completable) == null) continue;
                    boolean d = this.done;
                    T v = this.item;
                    if (d && v == null) {
                        this.completable = null;
                        Throwable ex = this.error;
                        if (ex == null) {
                            cf.complete(false);
                        } else {
                            cf.completeExceptionally(ex);
                        }
                        return;
                    }
                    if (v == null) continue;
                    this.current = this.item;
                    this.item = null;
                    this.completable = null;
                    cf.complete(true);
                } while (this.decrementAndGet() != 0);
            }
        }
    }
}

