/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import java.util.Iterator;
import java.util.concurrent.CompletionStage;

final class AsyncFromIterable<T>
implements AsyncEnumerable<T> {
    final Iterable<T> iterable;

    AsyncFromIterable(Iterable<T> iterable) {
        this.iterable = iterable;
    }

    @Override
    public AsyncEnumerator<T> enumerator() {
        return new FromIteratorEnumerator<T>(this.iterable.iterator());
    }

    static final class FromIteratorEnumerator<T>
    implements AsyncEnumerator<T> {
        final Iterator<T> iterator;
        T current;

        FromIteratorEnumerator(Iterator<T> iterable) {
            this.iterator = iterable;
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            if (this.iterator.hasNext()) {
                this.current = this.iterator.next();
                return AsyncEnumerable.TRUE;
            }
            this.current = null;
            return AsyncEnumerable.FALSE;
        }

        @Override
        public T current() {
            return this.current;
        }

        @Override
        public void cancel() {
        }
    }
}

