/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import hu.akarnokd.asyncenum.AsyncError;
import java.util.Iterator;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;

final class AsyncFromStream<T>
implements AsyncEnumerable<T> {
    final Stream<T> stream;

    AsyncFromStream(Stream<T> stream) {
        this.stream = stream;
    }

    @Override
    public AsyncEnumerator<T> enumerator() {
        try {
            return new StreamEnumerator(this.stream.iterator(), this.stream);
        }
        catch (RuntimeException ex) {
            return new AsyncError(ex);
        }
    }

    static final class StreamEnumerator<T>
    extends AtomicBoolean
    implements AsyncEnumerator<T> {
        final Iterator<T> source;
        final Stream closeable;
        T current;

        StreamEnumerator(Iterator<T> source, Stream closeable) {
            this.source = source;
            this.closeable = closeable;
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            if (this.source.hasNext()) {
                this.current = this.source.next();
                return AsyncEnumerable.TRUE;
            }
            this.current = null;
            this.cancel();
            return AsyncEnumerable.FALSE;
        }

        @Override
        public T current() {
            return this.current;
        }

        @Override
        public void cancel() {
            if (this.compareAndSet(false, true)) {
                this.closeable.close();
            }
        }
    }
}

