/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import hu.akarnokd.asyncenum.SyncEmitter;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;

final class AsyncGenerate<T, S>
implements AsyncEnumerable<T> {
    final Supplier<S> state;
    final BiFunction<S, SyncEmitter<T>, S> generator;
    final Consumer<? super S> releaseState;

    AsyncGenerate(Supplier<S> state, BiFunction<S, SyncEmitter<T>, S> generator, Consumer<? super S> releaseState) {
        this.state = state;
        this.generator = generator;
        this.releaseState = releaseState;
    }

    @Override
    public AsyncEnumerator<T> enumerator() {
        return new GenerateEnumerator<T, S>(this.state.get(), this.generator, this.releaseState);
    }

    static final class GenerateEnumerator<T, S>
    extends AtomicBoolean
    implements AsyncEnumerator<T>,
    SyncEmitter<T> {
        final BiFunction<S, SyncEmitter<T>, S> generator;
        final Consumer<? super S> releaseState;
        S state;
        T result;
        boolean hasValue;
        boolean done;
        Throwable error;

        GenerateEnumerator(S state, BiFunction<S, SyncEmitter<T>, S> generator, Consumer<? super S> releaseState) {
            this.state = state;
            this.generator = generator;
            this.releaseState = releaseState;
        }

        void cleanup() {
            if (this.compareAndSet(false, true)) {
                S s = this.state;
                this.state = null;
                this.releaseState.accept(s);
            }
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            if (this.error != null) {
                this.cleanup();
                return CompletableFuture.failedStage(this.error);
            }
            if (this.done) {
                this.cleanup();
                return AsyncEnumerable.FALSE;
            }
            this.hasValue = false;
            this.result = null;
            this.state = this.generator.apply(this.state, this);
            if (this.hasValue) {
                return AsyncEnumerable.TRUE;
            }
            this.cleanup();
            if (this.error != null) {
                return CompletableFuture.failedStage(this.error);
            }
            if (this.done) {
                return AsyncEnumerable.FALSE;
            }
            return CompletableFuture.failedStage(new IllegalStateException("None of the SyncEmitter methods were called in this round"));
        }

        @Override
        public T current() {
            return this.result;
        }

        @Override
        public void cancel() {
            this.cleanup();
        }

        @Override
        public void next(T item) {
            if (this.hasValue) {
                this.result = null;
                this.error = this.error == null ? new IllegalStateException("next() called multiple times") : new IllegalStateException("next() called multiple times", this.error);
            } else {
                this.hasValue = true;
                this.result = item;
            }
        }

        @Override
        public void error(Throwable error) {
            this.error = this.error != null ? new IllegalStateException("error() called multiple times", error) : error;
        }

        @Override
        public void stop() {
            this.done = true;
        }
    }
}

