/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import hu.akarnokd.asyncenum.AsyncError;
import hu.akarnokd.asyncenum.GroupedAsyncEnumerable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;

final class AsyncGroupBy<T, K, V>
implements AsyncEnumerable<GroupedAsyncEnumerable<V, K>> {
    final AsyncEnumerable<T> source;
    final Function<? super T, ? extends K> keySelector;
    final Function<? super T, ? extends V> valueSelector;

    AsyncGroupBy(AsyncEnumerable<T> source, Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector) {
        this.source = source;
        this.keySelector = keySelector;
        this.valueSelector = valueSelector;
    }

    @Override
    public AsyncEnumerator<GroupedAsyncEnumerable<V, K>> enumerator() {
        return new GroupByEnumerator<T, K, V>(this.source.enumerator(), this.keySelector, this.valueSelector);
    }

    static final class GroupByEnumerator<T, K, V>
    implements AsyncEnumerator<GroupedAsyncEnumerable<V, K>>,
    BiConsumer<Boolean, Throwable> {
        final AsyncEnumerator<T> source;
        final Function<? super T, ? extends K> keySelector;
        final Function<? super T, ? extends V> valueSelector;
        final AtomicInteger sourceWip;
        final AtomicInteger wip;
        final AtomicInteger dispatchWip;
        final ConcurrentMap<K, GroupedEnumerator<T, K, V>> groups;
        final AtomicBoolean cancelled;
        final AtomicInteger active;
        volatile CompletableFuture<Boolean> completable;
        volatile GroupedAsyncEnumerable<V, K> current;
        volatile boolean done;
        volatile Throwable error;

        GroupByEnumerator(AsyncEnumerator<T> source, Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector) {
            this.source = source;
            this.keySelector = keySelector;
            this.valueSelector = valueSelector;
            this.sourceWip = new AtomicInteger();
            this.wip = new AtomicInteger();
            this.dispatchWip = new AtomicInteger();
            this.groups = new ConcurrentHashMap<K, GroupedEnumerator<T, K, V>>();
            this.cancelled = new AtomicBoolean();
            this.active = new AtomicInteger(1);
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            this.current = null;
            CompletableFuture<Boolean> cf = new CompletableFuture<Boolean>();
            this.completable = cf;
            this.consumersReady();
            this.drain();
            return cf;
        }

        @Override
        public GroupedAsyncEnumerable<V, K> current() {
            return this.current;
        }

        @Override
        public void cancel() {
            if (this.cancelled.compareAndSet(false, true)) {
                if (this.active.decrementAndGet() == 0) {
                    this.source.cancel();
                } else {
                    this.consumersReady();
                }
            }
        }

        void remove(K key) {
            this.groups.remove(key);
            if (this.active.decrementAndGet() == 0) {
                this.source.cancel();
            } else {
                this.consumersReady();
            }
        }

        @Override
        public void accept(Boolean aBoolean, Throwable throwable) {
            if (throwable != null) {
                for (GroupedEnumerator gr : this.groups.values()) {
                    gr.error = throwable;
                    gr.done = true;
                    gr.drain();
                }
                this.groups.clear();
                this.error = throwable;
                this.drain();
            } else if (aBoolean.booleanValue()) {
                T v = this.source.current();
                K key = this.keySelector.apply(v);
                V value = this.valueSelector.apply(v);
                boolean isNew = false;
                GroupedEnumerator gr = (GroupedEnumerator)this.groups.get(key);
                if (gr == null) {
                    if (this.cancelled.get()) {
                        this.consumersReady();
                        return;
                    }
                    this.active.getAndIncrement();
                    gr = new GroupedEnumerator(key, this);
                    this.groups.put(key, gr);
                    isNew = true;
                }
                if (isNew) {
                    this.current = gr;
                    this.drain();
                }
                gr.result = value;
                gr.hasValue = true;
                gr.drain();
            } else {
                for (GroupedEnumerator gr : this.groups.values()) {
                    gr.done = true;
                    gr.drain();
                }
                this.groups.clear();
                this.done = true;
                this.drain();
            }
        }

        void nextSource() {
            if (this.sourceWip.getAndIncrement() == 0) {
                do {
                    this.source.moveNext().whenComplete(this);
                } while (this.sourceWip.decrementAndGet() != 0);
            }
        }

        void consumersReady() {
            if (this.dispatchWip.getAndIncrement() == 0) {
                do {
                    if (this.completable == null && !this.cancelled.get()) continue;
                    int s = 0;
                    int r = 0;
                    for (GroupedEnumerator gr : this.groups.values()) {
                        if (gr.nonFirst && gr.completable != null) {
                            ++r;
                        }
                        ++s;
                    }
                    if (s != r) continue;
                    this.nextSource();
                } while (this.dispatchWip.decrementAndGet() != 0);
            }
        }

        void drain() {
            if (this.wip.getAndIncrement() == 0) {
                do {
                    CompletableFuture<Boolean> cf;
                    if ((cf = this.completable) == null) continue;
                    this.completable = null;
                    Throwable ex = this.error;
                    if (ex != null) {
                        cf.completeExceptionally(ex);
                        return;
                    }
                    if (this.done) {
                        cf.complete(false);
                        continue;
                    }
                    cf.complete(true);
                } while (this.wip.decrementAndGet() != 0);
            }
        }

        static final class GroupedEnumerator<T, K, V>
        implements GroupedAsyncEnumerable<V, K>,
        AsyncEnumerator<V> {
            final K key;
            final GroupByEnumerator<T, K, V> parent;
            final AtomicBoolean once;
            final AtomicBoolean cancelled;
            final AtomicInteger wip;
            volatile CompletableFuture<Boolean> completable;
            V result;
            volatile boolean hasValue;
            volatile boolean done;
            Throwable error;
            volatile boolean nonFirst;

            GroupedEnumerator(K key, GroupByEnumerator<T, K, V> parent) {
                this.key = key;
                this.parent = parent;
                this.once = new AtomicBoolean();
                this.wip = new AtomicInteger();
                this.cancelled = new AtomicBoolean();
            }

            @Override
            public K key() {
                return this.key;
            }

            @Override
            public AsyncEnumerator<V> enumerator() {
                if (this.once.compareAndSet(false, true)) {
                    return this;
                }
                return new AsyncError(new IllegalStateException("Only one AsyncEnumerator allowed"));
            }

            @Override
            public CompletionStage<Boolean> moveNext() {
                CompletableFuture<Boolean> cf = new CompletableFuture<Boolean>();
                this.completable = cf;
                if (this.nonFirst) {
                    this.result = null;
                    this.hasValue = false;
                    this.parent.consumersReady();
                } else {
                    this.nonFirst = true;
                }
                this.drain();
                return cf;
            }

            @Override
            public V current() {
                return this.result;
            }

            void drain() {
                if (this.wip.getAndIncrement() == 0) {
                    do {
                        CompletableFuture<Boolean> cf;
                        if ((cf = this.completable) == null) continue;
                        if (this.done) {
                            Throwable ex = this.error;
                            if (ex == null) {
                                cf.complete(false);
                            } else {
                                cf.completeExceptionally(ex);
                            }
                            return;
                        }
                        if (!this.hasValue) continue;
                        this.completable = null;
                        cf.complete(true);
                    } while (this.wip.decrementAndGet() != 0);
                }
            }

            @Override
            public void cancel() {
                if (this.cancelled.compareAndSet(false, true)) {
                    this.parent.remove(this.key);
                }
            }
        }
    }
}

