/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;

final class AsyncIgnoreElements<T>
implements AsyncEnumerable<T> {
    final AsyncEnumerable<T> source;

    AsyncIgnoreElements(AsyncEnumerable<T> source) {
        this.source = source;
    }

    @Override
    public AsyncEnumerator<T> enumerator() {
        return new IgnoreElementsEnumerator<T>(this.source.enumerator());
    }

    static final class IgnoreElementsEnumerator<T>
    extends AtomicInteger
    implements AsyncEnumerator<T>,
    BiConsumer<Boolean, Throwable> {
        final AsyncEnumerator<T> source;
        CompletableFuture<Boolean> completable;
        volatile boolean cancelled;

        IgnoreElementsEnumerator(AsyncEnumerator<T> source) {
            this.source = source;
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            CompletableFuture<Boolean> cf = new CompletableFuture<Boolean>();
            this.completable = cf;
            this.nextSource();
            return cf;
        }

        void nextSource() {
            if (this.getAndIncrement() == 0) {
                do {
                    if (this.cancelled) {
                        return;
                    }
                    this.source.moveNext().whenComplete(this);
                } while (this.decrementAndGet() != 0);
            }
        }

        @Override
        public T current() {
            return null;
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.source.cancel();
        }

        @Override
        public void accept(Boolean aBoolean, Throwable throwable) {
            if (throwable != null) {
                this.completable.completeExceptionally(throwable);
                return;
            }
            if (aBoolean.booleanValue()) {
                this.nextSource();
            } else {
                this.completable.complete(false);
            }
        }
    }
}

