/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

final class AsyncInterval
implements AsyncEnumerable<Long> {
    final long initialDelay;
    final long period;
    final TimeUnit unit;
    final ScheduledExecutorService executor;

    AsyncInterval(long initialDelay, long period, TimeUnit unit, ScheduledExecutorService executor) {
        this.initialDelay = initialDelay;
        this.period = period;
        this.unit = unit;
        this.executor = executor;
    }

    @Override
    public AsyncEnumerator<Long> enumerator() {
        IntervalEnumerator enumerator = new IntervalEnumerator();
        enumerator.task = this.executor.scheduleAtFixedRate(enumerator, this.initialDelay, this.period, this.unit);
        return enumerator;
    }

    static final class IntervalEnumerator
    extends AtomicInteger
    implements AsyncEnumerator<Long>,
    Runnable {
        final AtomicLong available = new AtomicLong();
        Future<?> task;
        long emitted;
        volatile CompletableFuture<Boolean> completable;
        Long result;

        IntervalEnumerator() {
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            this.result = null;
            CompletableFuture<Boolean> cf = new CompletableFuture<Boolean>();
            this.completable = cf;
            this.drain();
            return cf;
        }

        @Override
        public Long current() {
            return this.result;
        }

        @Override
        public void run() {
            this.available.getAndIncrement();
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() == 0) {
                do {
                    if (this.emitted == this.available.get()) continue;
                    this.result = this.emitted++;
                    this.completable.complete(true);
                } while (this.decrementAndGet() != 0);
            }
        }

        @Override
        public void cancel() {
            this.task.cancel(false);
        }
    }
}

