/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;

final class AsyncLast<T>
implements AsyncEnumerable<T> {
    final AsyncEnumerable<T> source;

    AsyncLast(AsyncEnumerable<T> source) {
        this.source = source;
    }

    @Override
    public AsyncEnumerator<T> enumerator() {
        return new LastEnumerator<T>(this.source.enumerator());
    }

    static final class LastEnumerator<T>
    extends AtomicInteger
    implements AsyncEnumerator<T>,
    BiConsumer<Boolean, Throwable> {
        final AsyncEnumerator<T> source;
        volatile boolean cancelled;
        CompletableFuture<Boolean> completable;
        T result;
        boolean once;
        boolean hasValue;

        LastEnumerator(AsyncEnumerator<T> source) {
            this.source = source;
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            if (this.once) {
                this.result = null;
                return AsyncEnumerable.FALSE;
            }
            this.once = true;
            CompletableFuture<Boolean> cf = new CompletableFuture<Boolean>();
            this.completable = cf;
            this.nextSource();
            return cf;
        }

        void nextSource() {
            if (this.getAndIncrement() == 0) {
                do {
                    this.source.moveNext().whenComplete(this);
                } while (this.decrementAndGet() != 0);
            }
        }

        @Override
        public T current() {
            return this.result;
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.source.cancel();
        }

        @Override
        public void accept(Boolean aBoolean, Throwable throwable) {
            if (throwable != null) {
                this.completable.completeExceptionally(throwable);
                return;
            }
            if (aBoolean.booleanValue()) {
                if (!this.hasValue) {
                    this.hasValue = true;
                }
                this.result = this.source.current();
                this.nextSource();
            } else {
                this.completable.complete(this.hasValue);
            }
        }
    }
}

