/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

final class AsyncMap<T, R>
implements AsyncEnumerable<R> {
    final AsyncEnumerable<T> source;
    final Function<? super T, ? extends R> mapper;

    AsyncMap(AsyncEnumerable<T> source, Function<? super T, ? extends R> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    @Override
    public AsyncEnumerator<R> enumerator() {
        return new MapEnumerator<T, R>(this.source.enumerator(), this.mapper);
    }

    static final class MapEnumerator<T, R>
    implements AsyncEnumerator<R> {
        final AsyncEnumerator<T> source;
        final Function<? super T, ? extends R> mapper;

        MapEnumerator(AsyncEnumerator<T> source, Function<? super T, ? extends R> mapper) {
            this.source = source;
            this.mapper = mapper;
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            return this.source.moveNext();
        }

        @Override
        public R current() {
            return this.mapper.apply(this.source.current());
        }

        @Override
        public void cancel() {
            this.source.cancel();
        }
    }
}

