/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import java.util.Comparator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;

final class AsyncMax<T>
implements AsyncEnumerable<T> {
    final AsyncEnumerable<T> source;
    final Comparator<? super T> comparator;

    AsyncMax(AsyncEnumerable<T> source, Comparator<? super T> comparator) {
        this.source = source;
        this.comparator = comparator;
    }

    @Override
    public AsyncEnumerator<T> enumerator() {
        return new SumLongEnumerator<T>(this.source.enumerator(), this.comparator);
    }

    static final class SumLongEnumerator<T>
    extends AtomicInteger
    implements AsyncEnumerator<T>,
    BiConsumer<Boolean, Throwable> {
        final AsyncEnumerator<T> source;
        final Comparator<? super T> comparator;
        boolean hasValue;
        T max;
        T result;
        boolean done;
        CompletableFuture<Boolean> completable;
        volatile boolean cancelled;

        SumLongEnumerator(AsyncEnumerator<T> source, Comparator<? super T> comparator) {
            this.source = source;
            this.comparator = comparator;
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            if (this.done) {
                this.result = null;
                return AsyncEnumerable.FALSE;
            }
            this.completable = new CompletableFuture();
            this.collectSource();
            return this.completable;
        }

        @Override
        public T current() {
            return this.result;
        }

        void collectSource() {
            if (this.getAndIncrement() == 0) {
                do {
                    if (this.cancelled) {
                        return;
                    }
                    this.source.moveNext().whenComplete(this);
                } while (this.decrementAndGet() != 0);
            }
        }

        @Override
        public void accept(Boolean aBoolean, Throwable throwable) {
            if (throwable != null) {
                this.done = true;
                this.completable.completeExceptionally(throwable);
                return;
            }
            if (aBoolean.booleanValue()) {
                if (this.hasValue) {
                    T curr = this.source.current();
                    if (this.comparator.compare(this.max, curr) <= 0) {
                        this.max = curr;
                    }
                } else {
                    this.hasValue = true;
                    this.max = this.source.current();
                }
                this.collectSource();
            } else {
                this.done = true;
                if (this.hasValue) {
                    this.result = this.max;
                    this.completable.complete(true);
                } else {
                    this.completable.complete(false);
                }
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.source.cancel();
        }
    }
}

