/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncCompletableFuture;
import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;

final class AsyncObserveOn<T>
implements AsyncEnumerable<T> {
    final AsyncEnumerable<T> source;
    final Executor executor;

    AsyncObserveOn(AsyncEnumerable<T> source, Executor executor) {
        this.source = source;
        this.executor = executor;
    }

    @Override
    public AsyncEnumerator<T> enumerator() {
        return new ObserveOnEnumerator<T>(this.source.enumerator(), this.executor);
    }

    static final class ObserveOnEnumerator<T>
    implements AsyncEnumerator<T> {
        final AsyncEnumerator<T> source;
        final Executor executor;

        ObserveOnEnumerator(AsyncEnumerator<T> source, Executor executor) {
            this.source = source;
            this.executor = executor;
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            AsyncCompletableFuture<Boolean> cf = new AsyncCompletableFuture<Boolean>();
            this.source.moveNext().whenCompleteAsync(cf, this.executor);
            return cf;
        }

        @Override
        public T current() {
            return this.source.current();
        }

        @Override
        public void cancel() {
            this.source.cancel();
        }
    }
}

