/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import hu.akarnokd.asyncenum.AsyncEnumeratorHelper;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;

final class AsyncOnErrorResume<T>
implements AsyncEnumerable<T> {
    final AsyncEnumerable<T> source;
    final Function<? super Throwable, ? extends AsyncEnumerable<? extends T>> resumeMapper;

    AsyncOnErrorResume(AsyncEnumerable<T> source, Function<? super Throwable, ? extends AsyncEnumerable<? extends T>> resumeMapper) {
        this.source = source;
        this.resumeMapper = resumeMapper;
    }

    @Override
    public AsyncEnumerator<T> enumerator() {
        return new OnErrorResumeEnumerator<T>(this.source.enumerator(), this.resumeMapper);
    }

    static final class OnErrorResumeEnumerator<T>
    implements AsyncEnumerator<T>,
    BiConsumer<Boolean, Throwable> {
        final Function<? super Throwable, ? extends AsyncEnumerable<? extends T>> resumeMapper;
        final AtomicReference<AsyncEnumerator<T>> source;
        T result;
        CompletableFuture<Boolean> completable;
        boolean inFallback;

        OnErrorResumeEnumerator(AsyncEnumerator<T> source, Function<? super Throwable, ? extends AsyncEnumerable<? extends T>> resumeMapper) {
            this.source = new AtomicReference<AsyncEnumerator<T>>(source);
            this.resumeMapper = resumeMapper;
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            CompletableFuture<Boolean> cf = new CompletableFuture<Boolean>();
            this.completable = cf;
            this.source.getPlain().moveNext().whenComplete(this);
            return cf;
        }

        @Override
        public T current() {
            return this.result;
        }

        @Override
        public void accept(Boolean aBoolean, Throwable throwable) {
            CompletableFuture<Boolean> cf = this.completable;
            if (this.inFallback) {
                if (throwable != null) {
                    this.result = null;
                    cf.completeExceptionally(throwable);
                    return;
                }
            } else if (throwable != null) {
                this.inFallback = true;
                this.result = null;
                if (AsyncEnumeratorHelper.replace(this.source, this.resumeMapper.apply(throwable).enumerator())) {
                    this.source.getPlain().moveNext().whenComplete(this);
                }
                return;
            }
            if (aBoolean.booleanValue()) {
                this.result = this.source.getPlain().current();
                cf.complete(true);
            } else {
                this.result = null;
                cf.complete(false);
            }
        }

        @Override
        public void cancel() {
            AsyncEnumeratorHelper.cancel(this.source);
        }
    }
}

