/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;

final class AsyncPublish<T, R>
implements AsyncEnumerable<R> {
    final AsyncEnumerable<T> source;
    final Function<? super AsyncEnumerable<T>, ? extends AsyncEnumerable<R>> handler;

    AsyncPublish(AsyncEnumerable<T> source, Function<? super AsyncEnumerable<T>, ? extends AsyncEnumerable<R>> handler) {
        this.source = source;
        this.handler = handler;
    }

    @Override
    public AsyncEnumerator<R> enumerator() {
        PublishCoordinator coordinator = new PublishCoordinator();
        coordinator.output = this.handler.apply(coordinator).enumerator();
        coordinator.source = this.source.enumerator();
        coordinator.enumeratorReady();
        return coordinator;
    }

    static final class PublishCoordinator<T, R>
    implements BiConsumer<Boolean, Throwable>,
    AsyncEnumerable<T>,
    AsyncEnumerator<R> {
        volatile AsyncEnumerator<T> source;
        AsyncEnumerator<R> output;
        final AtomicReference<PublishEnumerator<T, R>[]> enumerators = new AtomicReference<PublishEnumerator[]>(EMPTY);
        static final PublishEnumerator[] EMPTY = new PublishEnumerator[0];
        static final PublishEnumerator[] TERMINATED = new PublishEnumerator[0];
        final AtomicInteger enumeratorWip = new AtomicInteger();
        final AtomicInteger sourceWip = new AtomicInteger();
        final AtomicInteger outputWip = new AtomicInteger();
        volatile boolean cancelled;
        volatile CompletableFuture<Boolean> outputCompletable;
        R outputResult;
        volatile boolean sourceDone;
        volatile Throwable sourceError;

        PublishCoordinator() {
        }

        boolean add(PublishEnumerator<T, R> en) {
            PublishEnumerator[] b;
            PublishEnumerator<T, R>[] a;
            do {
                if ((a = this.enumerators.getAcquire()) == TERMINATED) {
                    return false;
                }
                int n = a.length;
                b = new PublishEnumerator[n + 1];
                System.arraycopy(a, 0, b, 0, n);
                b[n] = en;
            } while (!this.enumerators.compareAndSet(a, b));
            return true;
        }

        void remove(PublishEnumerator<T, R> en) {
            PublishEnumerator[] b;
            PublishEnumerator<T, R>[] a;
            do {
                int n;
                if ((n = (a = this.enumerators.getAcquire()).length) == 0) {
                    return;
                }
                int j = -1;
                for (int i = 0; i < n; ++i) {
                    if (a[i] != en) continue;
                    j = i;
                    break;
                }
                if (j < 0) break;
                if (n == 1) {
                    b = EMPTY;
                    continue;
                }
                b = new PublishEnumerator[n - 1];
                System.arraycopy(a, 0, b, 0, j);
                System.arraycopy(a, j + 1, b, j, n - j - 1);
            } while (!this.enumerators.compareAndSet(a, b));
        }

        void enumeratorReady() {
            if (this.enumeratorWip.getAndIncrement() == 0) {
                do {
                    AsyncEnumerator<T> en;
                    if ((en = this.source) == null) continue;
                    PublishEnumerator<T, R>[] ens = this.enumerators.getAcquire();
                    boolean canRequest = ens.length != 0;
                    for (PublishEnumerator<T, R> pe : ens) {
                        if (pe.cancelled || pe.requested != pe.emitted) continue;
                        canRequest = false;
                        break;
                    }
                    if (!canRequest) continue;
                    for (PublishEnumerator<T, R> pe : ens) {
                        ++pe.emitted;
                    }
                    this.nextSource(en);
                } while (this.enumeratorWip.decrementAndGet() != 0);
            }
        }

        void nextSource(AsyncEnumerator<T> en) {
            if (this.sourceWip.getAndIncrement() == 0) {
                do {
                    if (this.cancelled) {
                        return;
                    }
                    en.moveNext().whenComplete(this);
                } while (this.sourceWip.decrementAndGet() != 0);
            }
        }

        @Override
        public AsyncEnumerator<T> enumerator() {
            PublishEnumerator pe = new PublishEnumerator(this);
            if (!this.add(pe)) {
                pe.error = this.sourceError;
                pe.done = this.sourceDone;
            }
            pe.drain();
            return pe;
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            CompletableFuture<Boolean> cf = new CompletableFuture<Boolean>();
            this.outputCompletable = cf;
            this.nextOutput();
            return cf;
        }

        @Override
        public R current() {
            return this.outputResult;
        }

        @Override
        public void accept(Boolean aBoolean, Throwable throwable) {
            if (throwable != null) {
                this.sourceError = throwable;
                for (PublishEnumerator en : this.enumerators.getAndSet(TERMINATED)) {
                    en.error = throwable;
                    en.drain();
                }
                return;
            }
            if (aBoolean.booleanValue()) {
                T v = this.source.current();
                for (PublishEnumerator<T, R> en : this.enumerators.getAcquire()) {
                    en.result = v;
                    en.hasResult = true;
                    en.drain();
                }
            } else {
                this.sourceDone = true;
                for (PublishEnumerator en : this.enumerators.getAndSet(TERMINATED)) {
                    en.done = true;
                    en.drain();
                }
            }
        }

        public void acceptOutput(Boolean aBoolean, Throwable throwable) {
            if (throwable != null) {
                this.source.cancel();
                this.outputCompletable.completeExceptionally(throwable);
                return;
            }
            if (aBoolean.booleanValue()) {
                this.outputResult = this.output.current();
                this.outputCompletable.complete(true);
            } else {
                this.source.cancel();
                this.outputCompletable.complete(false);
            }
        }

        void nextOutput() {
            if (this.outputWip.getAndIncrement() == 0) {
                do {
                    if (this.cancelled) {
                        return;
                    }
                    this.output.moveNext().whenComplete(this::acceptOutput);
                } while (this.outputWip.decrementAndGet() != 0);
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.source.cancel();
            this.output.cancel();
        }

        static final class PublishEnumerator<T, R>
        extends AtomicInteger
        implements AsyncEnumerator<T> {
            final PublishCoordinator<T, R> parent;
            volatile long requested;
            long emitted;
            volatile CompletableFuture<Boolean> completable;
            T result;
            volatile boolean hasResult;
            volatile boolean done;
            volatile Throwable error;
            volatile boolean cancelled;
            boolean once;

            PublishEnumerator(PublishCoordinator<T, R> parent) {
                this.parent = parent;
            }

            @Override
            public CompletionStage<Boolean> moveNext() {
                if (this.once) {
                    this.result = null;
                    this.hasResult = false;
                } else {
                    this.once = true;
                }
                CompletableFuture<Boolean> cf = new CompletableFuture<Boolean>();
                this.completable = cf;
                ++this.requested;
                this.parent.enumeratorReady();
                this.drain();
                return cf;
            }

            @Override
            public T current() {
                return this.result;
            }

            @Override
            public void cancel() {
                this.cancelled = true;
                this.parent.remove(this);
                this.parent.enumeratorReady();
            }

            void drain() {
                if (this.getAndIncrement() == 0) {
                    do {
                        CompletableFuture<Boolean> cf;
                        if ((cf = this.completable) == null) continue;
                        Throwable ex = this.error;
                        if (ex != null) {
                            this.completable = null;
                            cf.completeExceptionally(ex);
                            return;
                        }
                        if (this.done) {
                            this.completable = null;
                            cf.complete(false);
                            return;
                        }
                        if (!this.hasResult) continue;
                        this.completable = null;
                        cf.complete(true);
                    } while (this.decrementAndGet() != 0);
                }
            }
        }
    }
}

