/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.asyncenum;

import hu.akarnokd.asyncenum.AsyncEnumerable;
import hu.akarnokd.asyncenum.AsyncEnumerator;
import java.util.concurrent.CompletionStage;

final class AsyncRange
implements AsyncEnumerable<Integer> {
    final int start;
    final int count;

    AsyncRange(int start, int count) {
        this.start = start;
        this.count = count;
    }

    @Override
    public AsyncEnumerator<Integer> enumerator() {
        return new AsyncRangeEnumerator(this.start, this.start + this.count);
    }

    static final class AsyncRangeEnumerator
    implements AsyncEnumerator<Integer> {
        final int end;
        int index;
        Integer current;

        AsyncRangeEnumerator(int start, int end) {
            this.index = start;
            this.end = end;
        }

        @Override
        public CompletionStage<Boolean> moveNext() {
            int idx = this.index;
            if (idx == this.end) {
                this.current = null;
                return AsyncEnumerable.FALSE;
            }
            this.current = idx;
            this.index = idx + 1;
            return AsyncEnumerable.TRUE;
        }

        @Override
        public Integer current() {
            return this.current;
        }

        @Override
        public void cancel() {
        }
    }
}

